/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.netxms.client.AgentPolicy;
import org.netxms.ui.eclipse.datacollection.widgets.AbstractPolicyEditor;
import org.netxms.ui.eclipse.widgets.AgentConfigEditor;

public class AgentConfigPolicyEditor
extends AbstractPolicyEditor {
    private AgentConfigEditor editor;
    private Button buttonExpandMacro;
    private int flags;

    public AgentConfigPolicyEditor(Composite parent, int style, AgentPolicy policy, IViewPart viewPart) {
        super(parent, style, policy, viewPart);
        this.flags = policy.getFlags();
        this.setLayout((Layout)new FillLayout());
        Composite mainArea = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainArea.setLayout((Layout)layout);
        this.buttonExpandMacro = new Button(mainArea, 32);
        this.buttonExpandMacro.setText("Expand macro");
        this.buttonExpandMacro.setLayoutData((Object)new GridData());
        this.buttonExpandMacro.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AgentConfigPolicyEditor.this.fireModifyListeners();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.editor = new AgentConfigEditor(mainArea, 2048, 768);
        this.editor.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AgentConfigPolicyEditor.this.fireModifyListeners();
                AgentConfigPolicyEditor.this.updateFindAndReplaceAction();
            }
        });
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.editor.setLayoutData((Object)gd);
        this.updateControlFromPolicy();
    }

    @Override
    public void updateControlFromPolicy() {
        this.editor.setText(this.getPolicy().getContent());
        this.flags = this.getPolicy().getFlags();
        this.buttonExpandMacro.setSelection(((long)this.flags & 1L) > 0L);
    }

    @Override
    public AgentPolicy updatePolicyFromControl() {
        this.getPolicy().setContent(this.editor.getText());
        this.flags = this.buttonExpandMacro.getSelection() ? (int)((long)this.flags | 1L) : (int)((long)this.flags & 0xFFFFFFFFFFFFFFFEL);
        this.getPolicy().setFlags(this.flags);
        return this.getPolicy();
    }

    public boolean setFocus() {
        return this.editor.setFocus();
    }

    public boolean canPerformFind() {
        return this.editor.getFindReplaceTarget().canPerformFind();
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return this.editor.getFindReplaceTarget().findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord);
    }

    public Point getSelection() {
        return this.editor.getFindReplaceTarget().getSelection();
    }

    public String getSelectionText() {
        return this.editor.getFindReplaceTarget().getSelectionText();
    }

    public boolean isEditable() {
        return true;
    }

    public void replaceSelection(String text) {
        this.editor.getFindReplaceTarget().replaceSelection(text);
    }

    @Override
    public boolean isFindAndReplaceRequired() {
        return true;
    }
}

