/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.widgets;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.constants.ColumnFilterType;
import org.netxms.client.constants.Severity;
import org.netxms.client.log.ColumnFilter;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.logviewer.Messages;
import org.netxms.ui.eclipse.logviewer.widgets.ConditionEditor;

public class SeverityConditionEditor
extends ConditionEditor {
    private static final String[] OPERATIONS;
    private Combo severity;

    static {
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.SeverityConditionEditor_Is;
        Messages.get();
        stringArray[1] = Messages.SeverityConditionEditor_IsNot;
        Messages.get();
        stringArray[2] = Messages.SeverityConditionEditor_Below;
        Messages.get();
        stringArray[3] = Messages.SeverityConditionEditor_Above;
        OPERATIONS = stringArray;
    }

    public SeverityConditionEditor(Composite parent) {
        super(parent);
    }

    @Override
    protected String[] getOperations() {
        return OPERATIONS;
    }

    @Override
    protected void createContent(ColumnFilter initialFilter) {
        this.severity = new Combo((Composite)this, 2056);
        int i = Severity.NORMAL.getValue();
        while (i <= Severity.CRITICAL.getValue()) {
            this.severity.add(StatusDisplayInfo.getStatusText((int)i));
            ++i;
        }
        this.severity.select(0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 0x1000000;
        this.severity.setLayoutData((Object)gd);
        if (initialFilter != null) {
            switch (initialFilter.getType()) {
                case EQUALS: {
                    this.setSelectedOperation(initialFilter.isNegated() ? 1 : 0);
                    break;
                }
                case LESS: {
                    this.setSelectedOperation(2);
                    break;
                }
                case GREATER: {
                    this.setSelectedOperation(3);
                    break;
                }
            }
            this.severity.select((int)initialFilter.getNumericValue());
        }
    }

    @Override
    public ColumnFilter createFilter() {
        switch (this.getSelectedOperation()) {
            case 0: {
                return new ColumnFilter(ColumnFilterType.EQUALS, (long)this.severity.getSelectionIndex());
            }
            case 1: {
                ColumnFilter filter = new ColumnFilter(ColumnFilterType.EQUALS, (long)this.severity.getSelectionIndex());
                filter.setNegated(true);
                return filter;
            }
            case 2: {
                return new ColumnFilter(ColumnFilterType.LESS, (long)this.severity.getSelectionIndex());
            }
            case 3: {
                return new ColumnFilter(ColumnFilterType.GREATER, (long)this.severity.getSelectionIndex());
            }
        }
        return new ColumnFilter(ColumnFilterType.EQUALS, (long)this.severity.getSelectionIndex());
    }
}

