/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.netxms.ui.eclipse.console.Activator;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class EclipseLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 1L;
    private String name;
    private ILog log = Activator.getDefault().getLog();

    public EclipseLogger(String name) {
        this.name = name;
    }

    private void writeLog(int severity, String message, Throwable exception) {
        this.log.log((IStatus)new Status(severity, this.name, message, exception));
    }

    private void formatAndWriteLog(int severity, String format, Object arg1, Object arg2) {
        FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.writeLog(severity, tp.getMessage(), tp.getThrowable());
    }

    private void formatAndWriteLog(int severity, String format, Object ... arguments) {
        FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        this.writeLog(severity, tp.getMessage(), tp.getThrowable());
    }

    public void debug(String message) {
        this.writeLog(1, message, null);
    }

    public void debug(String message, Object arg1) {
        this.formatAndWriteLog(1, message, arg1, (Object)null);
    }

    public void debug(String message, Object ... args) {
        this.formatAndWriteLog(1, message, args);
    }

    public void debug(String message, Throwable exception) {
        this.formatAndWriteLog(1, message, exception);
    }

    public void debug(String message, Object arg1, Object arg2) {
        this.formatAndWriteLog(1, message, arg1, arg2);
    }

    public void error(String message) {
        this.writeLog(4, message, null);
    }

    public void error(String message, Object arg1) {
        this.formatAndWriteLog(4, message, arg1, (Object)null);
    }

    public void error(String message, Object ... args) {
        this.formatAndWriteLog(4, message, args);
    }

    public void error(String message, Throwable exception) {
        this.formatAndWriteLog(4, message, exception);
    }

    public void error(String message, Object arg1, Object arg2) {
        this.formatAndWriteLog(4, message, arg1, arg2);
    }

    public void info(String message) {
        this.writeLog(1, message, null);
    }

    public void info(String message, Object arg1) {
        this.formatAndWriteLog(1, message, arg1, (Object)null);
    }

    public void info(String message, Object ... args) {
        this.formatAndWriteLog(1, message, args);
    }

    public void info(String message, Throwable exception) {
        this.writeLog(1, message, exception);
    }

    public void info(String message, Object arg1, Object arg2) {
        this.formatAndWriteLog(1, message, arg1, arg2);
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void trace(String message) {
        this.writeLog(1, message, null);
    }

    public void trace(String message, Object arg1) {
        this.formatAndWriteLog(1, message, arg1, (Object)null);
    }

    public void trace(String message, Object ... args) {
        this.formatAndWriteLog(1, message, args);
    }

    public void trace(String message, Throwable exception) {
        this.writeLog(1, message, exception);
    }

    public void trace(String message, Object arg1, Object arg2) {
        this.formatAndWriteLog(1, message, arg1, arg2);
    }

    public void warn(String message) {
        this.writeLog(2, message, null);
    }

    public void warn(String message, Object arg1) {
        this.formatAndWriteLog(2, message, arg1, (Object)null);
    }

    public void warn(String message, Object ... args) {
        this.formatAndWriteLog(2, message, args);
    }

    public void warn(String message, Throwable exception) {
        this.writeLog(2, message, exception);
    }

    public void warn(String message, Object arg1, Object arg2) {
        this.formatAndWriteLog(2, message, arg1, arg2);
    }
}

