/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages.helpers;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.AccessListElement;
import org.netxms.ui.eclipse.console.resources.ThemeEngine;

public class AccessListLabelProvider
extends WorkbenchLabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private final Color inheritedElementColor = ThemeEngine.getForegroundColor((String)"List.DisabledItem");

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getText(element);
            }
            case 1: {
                AccessListElement e = (AccessListElement)element;
                StringBuilder sb = new StringBuilder(16);
                sb.append(e.hasRead() ? (char)'R' : '-');
                sb.append(e.hasModify() ? (char)'M' : '-');
                sb.append(e.hasCreate() ? (char)'C' : '-');
                sb.append(e.hasDelete() ? (char)'D' : '-');
                sb.append(e.hasControl() ? (char)'O' : '-');
                sb.append(e.hasSendEvents() ? (char)'E' : '-');
                sb.append(e.hasReadAlarms() ? (char)'V' : '-');
                sb.append(e.hasAckAlarms() ? (char)'K' : '-');
                sb.append(e.hasTerminateAlarms() ? (char)'T' : '-');
                sb.append(e.hasPushData() ? (char)'P' : '-');
                sb.append(e.hasAccessControl() ? (char)'A' : '-');
                return sb.toString();
            }
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        return ((AccessListElement)element).isInherited() ? this.inheritedElementColor : null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }
}

