/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.objecttabs;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.widgets.LastValuesWidget;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.tools.VisibilityValidator;

public class LastValues
extends ObjectTab {
    private LastValuesWidget dataView;
    private boolean initShowFilter = true;

    protected void createTabContent(Composite parent) {
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.initShowFilter = LastValues.safeCast(settings.get("LastValuesTab.showFilter"), settings.getBoolean("LastValuesTab.showFilter"), this.initShowFilter);
        this.dataView = new LastValuesWidget(this.getViewPart(), parent, 0, this.getObject(), "LastValuesTab", new VisibilityValidator(){

            public boolean isVisible() {
                return LastValues.this.isActive();
            }
        });
        this.dataView.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                settings.put("LastValuesTab.showFilter", LastValues.this.dataView.isFilterEnabled());
            }
        });
        this.dataView.setAutoRefreshEnabled(true);
        this.dataView.setFilterCloseAction(new Action(){

            public void run() {
                LastValues.this.dataView.enableFilter(false);
                ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = service.getCommand("org.netxms.ui.eclipse.datacollection.commands.show_dci_filter");
                State state = command.getState("org.netxms.ui.eclipse.datacollection.commands.show_dci_filter.state");
                state.setValue((Object)false);
                service.refreshElements(command.getId(), null);
            }
        });
        this.dataView.enableFilter(this.initShowFilter);
    }

    private static boolean safeCast(String s, boolean b, boolean defval) {
        return s != null ? b : defval;
    }

    public void objectChanged(AbstractObject object) {
        this.dataView.setDataCollectionTarget(object);
        if (this.getViewPart().getSite().getPage().isPartVisible((IWorkbenchPart)this.getViewPart()) && this.isActive()) {
            this.dataView.refresh();
        }
    }

    public boolean showForObject(AbstractObject object) {
        return object instanceof DataCollectionTarget;
    }

    public void refresh() {
        this.dataView.refresh();
    }

    public void setFilterEnabled(boolean enabled) {
        this.dataView.enableFilter(enabled);
    }

    public void selected() {
        super.selected();
        this.refresh();
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("org.netxms.ui.eclipse.datacollection.commands.show_dci_filter");
        State state = command.getState("org.netxms.ui.eclipse.datacollection.commands.show_dci_filter.state");
        state.setValue((Object)this.dataView.isFilterEnabled());
        service.refreshElements(command.getId(), null);
    }
}

