/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views.helpers;

import java.util.Date;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.UserAgentNotification;
import org.netxms.ui.eclipse.agentmanager.views.helpers.UserAgentNotificationLabelProvider;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;

public class UserAgentNotificationFilter
extends ViewerFilter {
    private String filterString = null;
    private UserAgentNotificationLabelProvider provider;
    private boolean showAllOneTime = true;
    private boolean showAllOneScheduled = true;

    public UserAgentNotificationFilter(UserAgentNotificationLabelProvider provider) {
        this.provider = provider;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        UserAgentNotification uam = (UserAgentNotification)element;
        if (!this.showAllOneTime && uam.getEndTime().getTime() == 0L && uam.getCreationTime().before(new Date(System.currentTimeMillis() - 3600000L))) {
            return false;
        }
        if (!this.showAllOneScheduled && uam.getEndTime().getTime() != 0L && uam.getEndTime().before(new Date())) {
            return false;
        }
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        if (Long.toString(uam.getId()).toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (uam.getMessage().toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (uam.getObjectNames().toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (RegionalSettings.getDateTimeFormat().format(uam.getEndTime()).contains(this.filterString)) {
            return true;
        }
        if (RegionalSettings.getDateTimeFormat().format(uam.getStartTime()).contains(this.filterString)) {
            return true;
        }
        if (uam.isRecalled() ? "yes".contains(this.filterString) : "no".contains(this.filterString)) {
            return true;
        }
        if (uam.isStartupNotification() ? "yes".contains(this.filterString) : "no".contains(this.filterString)) {
            return true;
        }
        if (RegionalSettings.getDateTimeFormat().format(uam.getCreationTime()).contains(this.filterString)) {
            return true;
        }
        return this.provider.getUserName(uam).contains(this.filterString);
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString.toLowerCase();
    }

    public boolean isShowAllOneTime() {
        return this.showAllOneTime;
    }

    public void setShowAllOneTime(boolean showAllOneTime) {
        this.showAllOneTime = showAllOneTime;
    }

    public boolean isShowAllOneScheduled() {
        return this.showAllOneScheduled;
    }

    public void setShowAllOneScheduled(boolean showAllOneScheduled) {
        this.showAllOneScheduled = showAllOneScheduled;
    }
}

