/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import java.util.HashSet;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.ObjectToolsConfig;
import org.netxms.ui.eclipse.objects.ObjectContext;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolExecutor;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolsCache;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ColorConverter;

public class ObjectTools
extends ElementWidget {
    private ObjectToolsConfig config;

    public ObjectTools(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = ObjectToolsConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new ObjectToolsConfig();
        }
        this.processCommonSettings(this.config);
        GridLayout layout = new GridLayout();
        layout.numColumns = this.config.getNumColumns();
        this.getContentArea().setLayout((Layout)layout);
        if (this.config.getTools() != null) {
            ObjectToolsConfig.Tool[] toolArray = this.config.getTools();
            int n = toolArray.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectToolsConfig.Tool t = toolArray[n2];
                this.createToolButton(t);
                ++n2;
            }
        }
    }

    private void createToolButton(final ObjectToolsConfig.Tool t) {
        Button b = new Button(this.getContentArea(), 0x800008);
        b.setText(t.name);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectTools.this.executeTool(t);
            }
        });
        b.setLayoutData((Object)new GridData(4, 4, true, false));
        if (t.color > 0) {
            b.setBackground(this.colors.create(ColorConverter.rgbFromInt((int)t.color)));
        }
    }

    protected void executeTool(ObjectToolsConfig.Tool t) {
        ObjectTool tool = ObjectToolsCache.getInstance().findTool(t.toolId);
        if (tool == null) {
            return;
        }
        AbstractObject object = ConsoleSharedData.getSession().findObjectById(this.getEffectiveObjectId(t.objectId));
        if (object == null) {
            return;
        }
        HashSet<ObjectContext> nodes = new HashSet<ObjectContext>();
        if (object instanceof AbstractNode) {
            nodes.add(new ObjectContext((AbstractObject)((AbstractNode)object), null));
        } else if (object instanceof Container || object instanceof ServiceRoot || object instanceof Subnet || object instanceof Cluster) {
            for (AbstractObject n : object.getAllChildren(2)) {
                nodes.add(new ObjectContext((AbstractObject)((AbstractNode)n), null));
            }
        }
        ObjectToolExecutor.execute(nodes, (ObjectTool)tool);
    }
}

