/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.Cookie;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.services.PreferenceInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PreferenceStore {
    private static final Logger logger = LoggerFactory.getLogger(PreferenceStore.class);
    private static final RGB DEFAULT_COLOR = new RGB(0, 0, 0);
    private static final String COOKIE_NAME = "nxmcStoreId";
    private static final int COOKIE_MAX_AGE_SEC = 7776000;
    private File storeFile;
    private Properties properties;
    private Properties defaultValues;
    private Set<IPropertyChangeListener> changeListeners = new HashSet();

    protected static void open(String stateDir) {
        PreferenceStore instance = new PreferenceStore(new File(stateDir + File.separator + "nxmc.preferences." + PreferenceStore.getStoreId()));
        ServiceLoader<PreferenceInitializer> loader = ServiceLoader.load(PreferenceInitializer.class, PreferenceStore.class.getClassLoader());
        for (PreferenceInitializer pi : loader) {
            logger.debug("Calling preference initializer " + pi.toString());
            try {
                pi.initializeDefaultPreferences(instance);
            }
            catch (Exception e) {
                logger.error("Exception in preference initializer", (Throwable)e);
            }
        }
        RWT.getUISession().setAttribute("netxms.preferenceStore", (Object)instance);
    }

    private static String getStoreId() {
        UISession uiSession = ContextProvider.getUISession();
        String result = (String)uiSession.getAttribute("nxmcStoreId");
        if (result == null) {
            result = PreferenceStore.getStoreIdFromCookie();
            if (result == null) {
                result = UUID.randomUUID().toString();
            }
            Cookie cookie = new Cookie("nxmcStoreId", result);
            cookie.setSecure(ContextProvider.getRequest().isSecure());
            cookie.setMaxAge(7776000);
            cookie.setHttpOnly(true);
            ContextProvider.getResponse().addCookie(cookie);
            uiSession.setAttribute("nxmcStoreId", (Object)result);
        }
        return result;
    }

    private static String getStoreIdFromCookie() {
        String result = null;
        Cookie[] cookies = ContextProvider.getRequest().getCookies();
        if (cookies != null) {
            for (int i = 0; result == null && i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!"nxmcStoreId".equals(cookie.getName())) continue;
                String value = cookie.getValue();
                try {
                    UUID.fromString(value);
                    result = value;
                    continue;
                }
                catch (IllegalArgumentException e) {
                    logger.warn("Invalid store ID \"" + value + "\" received from client");
                }
            }
        }
        return result;
    }

    public static PreferenceStore getInstance() {
        return (PreferenceStore)RWT.getUISession().getAttribute("netxms.preferenceStore");
    }

    public static PreferenceStore getInstance(Display display) {
        return (PreferenceStore)RWT.getUISession((Display)display).getAttribute("netxms.preferenceStore");
    }

    public static String serverProperty(String baseName, NXCSession session) {
        return baseName + "$" + Long.toString(session.getServerId());
    }

    public static String serverProperty(String baseName) {
        return PreferenceStore.serverProperty((String)baseName, (NXCSession)Registry.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreferenceStore(File storeFile) {
        this.storeFile = storeFile;
        this.defaultValues = new Properties();
        this.properties = new Properties(this.defaultValues);
        if (storeFile.exists()) {
            FileReader reader = null;
            try {
                reader = new FileReader(storeFile);
                this.properties.load(reader);
            }
            catch (Exception e) {
                logger.error("Error reading local preferences from " + storeFile.getAbsolutePath(), (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void save() {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.storeFile);
            this.properties.store(writer, "NXMC local preferences");
        }
        catch (Exception e) {
            logger.error("Error writing local preferences to " + this.storeFile.getAbsolutePath(), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        Set set = this.changeListeners;
        synchronized (set) {
            this.changeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        Set set = this.changeListeners;
        synchronized (set) {
            this.changeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChangeListeners(String property, String oldValue, String newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, (Object)oldValue, (Object)newValue);
        Set set = this.changeListeners;
        synchronized (set) {
            for (IPropertyChangeListener l : this.changeListeners) {
                l.propertyChange(event);
            }
        }
    }

    public String getAsString(String name) {
        return this.properties.getProperty(name);
    }

    public String getAsString(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    public boolean getAsBoolean(String name, boolean defaultValue) {
        String v = this.properties.getProperty(name);
        return v != null ? Boolean.parseBoolean(v) : defaultValue;
    }

    public int getAsInteger(String name, int defaultValue) {
        String v = this.properties.getProperty(name);
        if (v == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long getAsLong(String name, long defaultValue) {
        String v = this.properties.getProperty(name);
        if (v == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public double getAsDouble(String name, double defaultValue) {
        String v = this.properties.getProperty(name);
        if (v == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Point getAsPoint(String name, Point defaultValue) {
        String v = this.properties.getProperty(name);
        if (v == null) {
            return defaultValue;
        }
        String[] parts = v.split(",");
        if (parts.length != 2) {
            return defaultValue;
        }
        try {
            return new Point(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Point getAsPoint(String name, int defaultX, int defaultY) {
        String v = this.properties.getProperty(name);
        if (v == null) {
            return new Point(defaultX, defaultY);
        }
        String[] parts = v.split(",");
        if (parts.length != 2) {
            return new Point(defaultX, defaultY);
        }
        try {
            return new Point(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
        }
        catch (NumberFormatException e) {
            return new Point(defaultX, defaultY);
        }
    }

    public List<String> getAsStringList(String name) {
        int count = this.getAsInteger(name + ".Count", 0);
        ArrayList<String> list = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            list.add(this.getAsString(name + "." + Integer.toString(i), ""));
        }
        return list;
    }

    public String[] getAsStringArray(String name) {
        int count = this.getAsInteger(name + ".Count", 0);
        String[] list = new String[count];
        for (int i = 0; i < count; ++i) {
            list[i] = this.getAsString(name + "." + Integer.toString(i), "");
        }
        return list;
    }

    public RGB getAsColor(String name, RGB defaultValue) {
        String v = this.properties.getProperty(name);
        if (v == null) {
            return defaultValue;
        }
        String[] parts = v.split(",");
        if (parts.length != 3) {
            return defaultValue;
        }
        try {
            return new RGB(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public RGB getAsColor(String name) {
        return this.getAsColor(name, DEFAULT_COLOR);
    }

    public void set(String name, String value) {
        String oldValue = this.properties.getProperty(name);
        this.properties.setProperty(name, value);
        this.save();
        this.firePropertyChangeListeners(name, oldValue, value);
    }

    public void set(String name, boolean value) {
        this.set(name, Boolean.toString(value));
    }

    public void set(String name, int value) {
        this.set(name, Integer.toString(value));
    }

    public void set(String name, long value) {
        this.set(name, Long.toString(value));
    }

    public void set(String name, double value) {
        this.set(name, Double.toString(value));
    }

    public void set(String name, Point value) {
        this.set(name, Integer.toString(value.x) + "," + Integer.toString(value.y));
    }

    public void set(String name, Collection<String> value) {
        this.properties.setProperty(name + ".Count", Integer.toString(value.size()));
        int index = 0;
        for (String s : value) {
            this.properties.setProperty(name + "." + Integer.toString(index), s);
        }
        this.save();
        this.firePropertyChangeListeners(name, null, null);
    }

    public void set(String name, RGB value) {
        this.set(name, Integer.toString(value.red) + "," + Integer.toString(value.green) + "," + Integer.toString(value.blue));
    }

    public void setDefault(String name, String value) {
        this.defaultValues.setProperty(name, value);
    }

    public void setDefault(String name, boolean value) {
        this.setDefault(name, Boolean.toString(value));
    }

    public void setDefault(String name, int value) {
        this.setDefault(name, Integer.toString(value));
    }

    public void setDefault(String name, long value) {
        this.setDefault(name, Long.toString(value));
    }

    public void setDefault(String name, Point value) {
        this.setDefault(name, Integer.toString(value.x) + "," + Integer.toString(value.y));
    }

    public void setDefault(String name, Collection<String> value) {
        this.defaultValues.setProperty(name + ".Count", Integer.toString(value.size()));
        int index = 0;
        for (String s : value) {
            this.defaultValues.setProperty(name + "." + Integer.toString(index), s);
        }
    }

    public void setDefault(String name, RGB value) {
        this.setDefault(name, Integer.toString(value.red) + "," + Integer.toString(value.green) + "," + Integer.toString(value.blue));
    }
}

