/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages.helpers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class DciListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final I18n i18n = LocalizationHelper.getI18n(DciListLabelProvider.class);
    private NXCSession session;
    private Map<Long, String> dciNameCache = new HashMap();
    private List<ChartDciConfig> elementList;

    public DciListLabelProvider(List<ChartDciConfig> elementList) {
        this.elementList = elementList;
        this.session = Registry.getSession();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ChartDciConfig dci = (ChartDciConfig)element;
        switch (columnIndex) {
            case 0: {
                return Integer.toString(this.elementList.indexOf(dci) + 1);
            }
            case 1: {
                return dci.nodeId == 0L || dci.nodeId == 0xFFFFFFFFL ? this.i18n.tr("<context>") : this.session.getObjectName(dci.nodeId);
            }
            case 2: {
                if (dci.dciId == 0L) {
                    return dci.dciName;
                }
                String name = (String)this.dciNameCache.get(dci.dciId);
                return name != null ? name : this.i18n.tr("<unresolved>");
            }
            case 3: {
                return dci.name;
            }
            case 4: {
                return dci.color.equalsIgnoreCase("UNSET") ? this.i18n.tr("auto") : dci.color;
            }
        }
        return null;
    }

    public void resolveDciNames(Collection<ChartDciConfig> dciList) {
        new /* Unavailable Anonymous Inner Class!! */.runInForeground();
    }

    public void addCacheEntry(long nodeId, long dciId, String name) {
        this.dciNameCache.put(dciId, name);
    }
}

