/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.TimeUnit;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.ChartConfigurationChangeListener;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.GraphDefinition;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewWithContext;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.datacollection.dialogs.SaveGraphDlg;
import org.netxms.nxmc.modules.datacollection.propertypages.DataSources;
import org.netxms.nxmc.modules.datacollection.propertypages.GeneralChart;
import org.netxms.nxmc.modules.datacollection.propertypages.Graph;
import org.netxms.nxmc.modules.datacollection.views.HistoricalGraphView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.ViewRefreshController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class HistoricalGraphView
extends ViewWithContext
implements ChartConfigurationChangeListener {
    private static final I18n i18n = LocalizationHelper.getI18n(HistoricalGraphView.class);
    private static final Logger logger = LoggerFactory.getLogger(HistoricalGraphView.class);
    public static final String PREDEFINED_GRAPH_SUBID = "org.netxms.ui.eclipse.charts.predefinedGraph";
    private static final TimeUnit[] presetUnits = new TimeUnit[]{TimeUnit.MINUTE, TimeUnit.MINUTE, TimeUnit.HOUR, TimeUnit.HOUR, TimeUnit.HOUR, TimeUnit.HOUR, TimeUnit.DAY, TimeUnit.DAY, TimeUnit.DAY, TimeUnit.DAY, TimeUnit.DAY, TimeUnit.DAY};
    private static final int[] presetRanges = new int[]{10, 30, 1, 2, 4, 12, 1, 2, 5, 7, 31, 365};
    private static final String[] presetNames = new String[]{i18n.tr("Last 10 minutes"), i18n.tr("Last 30 minutes"), i18n.tr("Last hour"), i18n.tr("Last 2 hours"), i18n.tr("Last 4 hours"), i18n.tr("Last 12 hours"), i18n.tr("Last day"), i18n.tr("Last 2 days"), i18n.tr("Last 5 days"), i18n.tr("Last week"), i18n.tr("Last month"), i18n.tr("Last year")};
    private long objectId;
    private String fullName;
    private NXCSession session = Registry.getSession();
    private Chart chart = null;
    private boolean updateInProgress = false;
    private ViewRefreshController refreshController;
    private Composite chartParent = null;
    private GraphDefinition configuration = new GraphDefinition();
    private boolean multipleSourceNodes = false;
    private boolean showDeleteAction = false;
    private Action actionRefresh;
    private Action actionAutoRefresh;
    private Action actionZoomIn;
    private Action actionZoomOut;
    private Action actionAdjustX;
    private Action actionAdjustY;
    private Action actionAdjustBoth;
    private Action actionLogScale;
    private Action actionStacked;
    private Action actionAreaChart;
    private Action actionTranslucent;
    private Action actionShowLegend;
    private Action actionExtendedLegend;
    private Action actionLegendLeft;
    private Action actionLegendRight;
    private Action actionLegendTop;
    private Action actionLegendBottom;
    private Action actionProperties;
    private Action actionSave;
    private Action actionSaveAs;
    private Action actionSaveAsTemplate;
    private Action[] presetActions;
    private Action actionCopyImage;
    private Action actionSaveAsImage;
    private Action actionDelete;

    private static String buildId(AbstractObject object, List<ChartDciConfig> items) {
        StringBuilder sb = new StringBuilder("HistoricalGraphView");
        if (object != null) {
            sb.append('#');
            sb.append(object.getObjectId());
        }
        for (ChartDciConfig dci : items) {
            sb.append('#');
            sb.append(dci.dciId);
            sb.append('#');
            sb.append(dci.useRawValues);
        }
        return sb.toString();
    }

    public HistoricalGraphView(AbstractObject contextObject, List<ChartDciConfig> items) {
        super(i18n.tr("Line Chart"), ResourceManager.getImageDescriptor((String)"icons/object-views/chart-line.png"), HistoricalGraphView.buildId((AbstractObject)contextObject, items), false);
        this.objectId = contextObject.getObjectId();
        this.fullName = "Line Chart";
        this.refreshController = new ViewRefreshController((View)this, -1, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        if (items.size() == 1) {
            ChartDciConfig item = items.get(0);
            if (item.useRawValues) {
                this.setName(item.name + " " + i18n.tr("(raw)"));
            } else {
                this.setName(item.name);
            }
            AbstractObject object = this.session.findObjectById(item.nodeId);
            this.fullName = object != null ? object.getObjectName() + ": " + this.getName() : this.getName();
        } else {
            AbstractObject object;
            long nodeId = items.get((int)0).nodeId;
            for (ChartDciConfig item : items) {
                if (item.nodeId == nodeId) continue;
                nodeId = -1L;
                break;
            }
            if (nodeId != -1L && (object = this.session.findObjectById(nodeId)) != null) {
                this.fullName = String.format(i18n.tr("%s: Line Chart"), object.getObjectName());
            }
        }
        this.configuration.setDciList(items.toArray(new ChartDciConfig[items.size()]));
    }

    public HistoricalGraphView() {
        super(i18n.tr("Graph"), ResourceManager.getImageDescriptor((String)"icons/object-views/chart-line.png"), UUID.randomUUID().toString(), false);
        this.fullName = "Line Chart";
        this.refreshController = new ViewRefreshController((View)this, -1, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public View cloneView() {
        HistoricalGraphView view = (HistoricalGraphView)super.cloneView();
        view.objectId = this.objectId;
        view.fullName = this.fullName;
        view.multipleSourceNodes = this.multipleSourceNodes;
        view.configuration = new GraphDefinition(this.configuration);
        return view;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof AbstractObject && ((AbstractObject)context).getObjectId() == this.objectId;
    }

    protected void contextChanged(Object oldContext, Object newContext) {
        if (newContext == null || !(newContext instanceof AbstractObject) || ((AbstractObject)newContext).getObjectId() != this.objectId) {
            return;
        }
        this.configuration.setTimeFrom(new Date(System.currentTimeMillis() - this.configuration.getTimeRangeMillis()));
        this.configuration.setTimeTo(new Date(System.currentTimeMillis()));
        this.configureGraphFromSettings();
    }

    public boolean isCloseable() {
        return true;
    }

    public void initPredefinedGraph(GraphDefinition definition) {
        this.configuration = new GraphDefinition(definition);
        this.configuration.addChangeListener((ChartConfigurationChangeListener)this);
        this.configureGraphFromSettings();
    }

    private void configureGraphFromSettings() {
        if (this.chart != null) {
            this.chart.dispose();
        }
        if (!this.configuration.getTitle().isBlank()) {
            this.fullName = this.configuration.getTitle();
            this.setName(this.configuration.getTitle());
        }
        ChartConfiguration chartConfiguration = new ChartConfiguration();
        chartConfiguration.setTitle(this.configuration.getTitle());
        chartConfiguration.setLogScale(this.configuration.isLogScale());
        chartConfiguration.setGridVisible(this.configuration.isGridVisible());
        chartConfiguration.setLegendVisible(this.configuration.isLegendVisible());
        chartConfiguration.setLegendPosition(this.configuration.getLegendPosition());
        chartConfiguration.setExtendedLegend(this.configuration.isExtendedLegend());
        chartConfiguration.setStacked(this.configuration.isStacked());
        chartConfiguration.setTranslucent(this.configuration.isTranslucent());
        chartConfiguration.setArea(this.configuration.isArea());
        chartConfiguration.setLineWidth(this.configuration.getLineWidth());
        chartConfiguration.setUseMultipliers(this.configuration.isUseMultipliers());
        chartConfiguration.setAutoScale(this.configuration.isAutoScale());
        chartConfiguration.setModifyYBase(this.configuration.isModifyYBase());
        chartConfiguration.setMinYScaleValue(this.configuration.getMinYScaleValue());
        chartConfiguration.setMaxYScaleValue(this.configuration.getMaxYScaleValue());
        this.chart = new Chart(this.chartParent, 0, ChartType.LINE, chartConfiguration);
        this.createPopupMenu();
        int nodeId = 0;
        for (ChartDciConfig dci : this.configuration.getDciList()) {
            nodeId = (int)((long)nodeId | dci.nodeId);
            GraphItem item = new GraphItem(dci);
            if (this.configuration.isShowHostNames()) {
                item.setDescription(this.session.getObjectName(dci.nodeId) + " - " + dci.getLabel());
            }
            this.chart.addParameter(item);
        }
        this.updateDciInfo();
        if (this.chart.getItemCount() > 1) {
            this.multipleSourceNodes = (long)nodeId != this.configuration.getDciList()[0].nodeId;
        }
        this.chart.rebuild();
        this.chartParent.layout(true, true);
        this.updateChart();
        this.actionAutoRefresh.setChecked(this.configuration.isAutoRefresh());
        this.refreshMenuSelection();
        this.refreshController.setInterval(this.configuration.isAutoRefresh() ? this.configuration.getRefreshRate() : -1);
    }

    private void updateDciInfo() {
        3 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public void createContent(Composite parent) {
        this.chartParent = parent;
        this.createActions();
        this.configureGraphFromSettings();
        this.configuration.addChangeListener((ChartConfigurationChangeListener)this);
    }

    private void createPopupMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        this.chart.setMenuManager(menuManager);
    }

    private void getDataFromServer() {
        ChartDciConfig[] dciList = this.configuration.getDciList();
        if (dciList.length == 0) {
            this.updateInProgress = false;
            return;
        }
        5 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void createActions() {
        this.actionRefresh = new /* Unavailable Anonymous Inner Class!! */;
        this.actionProperties = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M3+ENTER", (IAction)this.actionProperties);
        this.actionAutoRefresh = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAutoRefresh.setChecked(this.configuration.isAutoRefresh());
        this.actionLogScale = new /* Unavailable Anonymous Inner Class!! */;
        this.actionLogScale.setChecked(this.configuration.isLogScale());
        this.actionZoomIn = new /* Unavailable Anonymous Inner Class!! */;
        this.actionZoomIn.setImageDescriptor(SharedIcons.ZOOM_IN);
        this.addKeyBinding("M1+=", (IAction)this.actionZoomIn);
        this.actionZoomOut = new /* Unavailable Anonymous Inner Class!! */;
        this.actionZoomOut.setImageDescriptor(SharedIcons.ZOOM_OUT);
        this.addKeyBinding("M1+-", (IAction)this.actionZoomOut);
        12 chartOwner = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAdjustX = HistoricalGraphView.createAction((ChartActionType)ChartActionType.ADJUST_X, (HistoricalChartOwner)chartOwner);
        this.actionAdjustY = HistoricalGraphView.createAction((ChartActionType)ChartActionType.ADJUST_Y, (HistoricalChartOwner)chartOwner);
        this.actionAdjustBoth = HistoricalGraphView.createAction((ChartActionType)ChartActionType.ADJUST_BOTH, (HistoricalChartOwner)chartOwner);
        this.addKeyBinding("M1+X", (IAction)this.actionAdjustX);
        this.addKeyBinding("M1+Y", (IAction)this.actionAdjustY);
        this.addKeyBinding("M1+0", (IAction)this.actionAdjustBoth);
        this.actionShowLegend = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowLegend.setChecked(this.configuration.isLegendVisible());
        this.addKeyBinding("M1+M3+L", (IAction)this.actionShowLegend);
        this.actionExtendedLegend = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExtendedLegend.setChecked(this.configuration.isExtendedLegend());
        this.addKeyBinding("M1+M3+E", (IAction)this.actionExtendedLegend);
        this.actionLegendLeft = new /* Unavailable Anonymous Inner Class!! */;
        this.actionLegendLeft.setChecked(this.configuration.getLegendPosition() == 1);
        this.actionLegendRight = new /* Unavailable Anonymous Inner Class!! */;
        this.actionLegendRight.setChecked(this.configuration.getLegendPosition() == 2);
        this.actionLegendTop = new /* Unavailable Anonymous Inner Class!! */;
        this.actionLegendTop.setChecked(this.configuration.getLegendPosition() == 4);
        this.actionLegendBottom = new /* Unavailable Anonymous Inner Class!! */;
        this.actionLegendBottom.setChecked(this.configuration.getLegendPosition() == 8);
        this.actionSave = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+S", (IAction)this.actionSave);
        this.actionSaveAs = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+M2+S", (IAction)this.actionSaveAs);
        this.actionSaveAsTemplate = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+T", (IAction)this.actionSaveAsTemplate);
        this.actionStacked = new /* Unavailable Anonymous Inner Class!! */;
        this.actionStacked.setChecked(this.configuration.isStacked());
        this.addKeyBinding("M1+M3+S", (IAction)this.actionStacked);
        this.actionTranslucent = new /* Unavailable Anonymous Inner Class!! */;
        this.actionTranslucent.setChecked(this.configuration.isTranslucent());
        this.addKeyBinding("M1+M3+T", (IAction)this.actionTranslucent);
        this.actionAreaChart = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAreaChart.setChecked(this.configuration.isArea());
        this.addKeyBinding("M1+M3+A", (IAction)this.actionAreaChart);
        this.presetActions = HistoricalGraphView.createPresetActions((PresetHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.actionCopyImage = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+C", (IAction)this.actionCopyImage);
        this.actionSaveAsImage = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+I", (IAction)this.actionSaveAsImage);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void refreshMenuSelection() {
        this.actionAutoRefresh.setChecked(this.configuration.isAutoRefresh());
        this.actionLogScale.setChecked(this.configuration.isLogScale());
        this.actionShowLegend.setChecked(this.configuration.isLegendVisible());
        this.actionExtendedLegend.setChecked(this.configuration.isExtendedLegend());
        this.actionStacked.setChecked(this.configuration.isStacked());
        this.actionTranslucent.setChecked(this.configuration.isTranslucent());
        this.actionAreaChart.setChecked(this.configuration.isArea());
        this.actionLegendLeft.setChecked(this.configuration.getLegendPosition() == 1);
        this.actionLegendRight.setChecked(this.configuration.getLegendPosition() == 2);
        this.actionLegendTop.setChecked(this.configuration.getLegendPosition() == 4);
        this.actionLegendBottom.setChecked(this.configuration.getLegendPosition() == 8);
    }

    private void fillContextMenu(IMenuManager manager) {
        MenuManager presets = new MenuManager(i18n.tr("&Presets"));
        for (int i = 0; i < this.presetActions.length; ++i) {
            presets.add((IAction)this.presetActions[i]);
        }
        MenuManager legend = new MenuManager(i18n.tr("&Legend"));
        legend.add((IAction)this.actionShowLegend);
        legend.add((IAction)this.actionExtendedLegend);
        legend.add((IContributionItem)new Separator());
        legend.add((IAction)this.actionLegendLeft);
        legend.add((IAction)this.actionLegendRight);
        legend.add((IAction)this.actionLegendTop);
        legend.add((IAction)this.actionLegendBottom);
        manager.add((IContributionItem)presets);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAreaChart);
        manager.add((IAction)this.actionStacked);
        manager.add((IAction)this.actionLogScale);
        manager.add((IAction)this.actionTranslucent);
        manager.add((IAction)this.actionAutoRefresh);
        manager.add((IContributionItem)legend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionProperties);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionSaveAs);
        manager.add((IAction)this.actionSaveAsImage);
        manager.add((IAction)this.actionCopyImage);
        if (this.showDeleteAction) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionDelete);
        }
    }

    protected void fillLocalMenu(IMenuManager manager) {
        MenuManager presets = new MenuManager(i18n.tr("&Presets"));
        for (int i = 0; i < this.presetActions.length; ++i) {
            presets.add((IAction)this.presetActions[i]);
        }
        MenuManager legend = new MenuManager(i18n.tr("&Legend"));
        legend.add((IAction)this.actionShowLegend);
        legend.add((IAction)this.actionExtendedLegend);
        legend.add((IContributionItem)new Separator());
        legend.add((IAction)this.actionLegendLeft);
        legend.add((IAction)this.actionLegendRight);
        legend.add((IAction)this.actionLegendTop);
        legend.add((IAction)this.actionLegendBottom);
        manager.add((IContributionItem)presets);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAreaChart);
        manager.add((IAction)this.actionStacked);
        manager.add((IAction)this.actionLogScale);
        manager.add((IAction)this.actionTranslucent);
        manager.add((IAction)this.actionAutoRefresh);
        manager.add((IContributionItem)legend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionSaveAs);
        manager.add((IAction)this.actionSaveAsTemplate);
        manager.add((IAction)this.actionSaveAsImage);
        manager.add((IAction)this.actionCopyImage);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionProperties);
    }

    private void setChartData(DciData[] data, Threshold[][] thresholds) {
        for (int i = 0; i < data.length; ++i) {
            this.chart.updateParameter(i, data[i], false);
        }
        this.chart.setThresholds(thresholds);
        this.chart.refresh();
    }

    private void updateChart() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        if (this.configuration.getTimePeriod().isBackFromNow()) {
            this.configuration.setTimeFrom(new Date(System.currentTimeMillis() - this.configuration.getTimeRangeMillis()));
            this.configuration.setTimeTo(new Date(System.currentTimeMillis()));
        }
        this.getDataFromServer();
    }

    public void refresh() {
        this.updateChart();
    }

    public void dispose() {
        this.refreshController.dispose();
        super.dispose();
    }

    public void onChartConfigurationChange(ChartConfiguration settings) {
        if (this.configuration == settings) {
            this.configureGraphFromSettings();
        }
    }

    private void saveGraph(String graphName, String errorMessage, boolean canBeOverwritten, boolean asTemplate, boolean showNameDialog) {
        GraphDefinition gs;
        SaveGraphDlg dlg;
        if (asTemplate && this.multipleSourceNodes) {
            String templateError = "More than one node is used for template creation.\nThis may cause undefined behaviour.";
            errorMessage = errorMessage == null ? templateError : errorMessage + "\n\n" + templateError;
        }
        int result = 0;
        GraphDefinition template = null;
        long oldGraphId = this.configuration.getId();
        if (asTemplate) {
            dlg = new SaveGraphDlg(this.getWindow().getShell(), graphName, errorMessage, canBeOverwritten);
            result = dlg.open();
            if (result == 1) {
                return;
            }
            template = new GraphDefinition(this.configuration);
            template.setId(0L);
            template.setOwnerId((long)this.session.getUserId());
            template.setAccessList(new ArrayList(0));
            template.setName(dlg.getName());
            template.setFlags(1);
        } else if (showNameDialog) {
            dlg = new SaveGraphDlg(this.getWindow().getShell(), graphName, errorMessage, canBeOverwritten);
            result = dlg.open();
            if (result == 1) {
                return;
            }
            this.configuration.setName(dlg.getName());
            if (!canBeOverwritten) {
                this.configuration.setId(0L);
            }
        } else {
            this.configuration.setName(graphName);
        }
        GraphDefinition graphDefinition = gs = asTemplate ? template : this.configuration;
        if (result == 101) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private void deletePredefinedGraph() {
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)i18n.tr("Delete Predefined Graphs"), (String)i18n.tr("Predefined graphs will be deleted. Are you sure?"))) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public static Action[] createPresetActions(PresetHandler handler) {
        Action[] actions = new Action[presetRanges.length];
        for (int i = 0; i < presetRanges.length; ++i) {
            Integer presetIndex = i;
            actions[i] = new /* Unavailable Anonymous Inner Class!! */;
        }
        return actions;
    }

    public static Action createAction(ChartActionType type, HistoricalChartOwner chartOwner) {
        33 action = null;
        switch (37.$SwitchMap$org$netxms$nxmc$modules$datacollection$views$HistoricalGraphView$ChartActionType[type.ordinal()]) {
            case 1: {
                action = new /* Unavailable Anonymous Inner Class!! */;
                action.setText(i18n.tr("&Adjust"));
                action.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/adjust.png"));
                break;
            }
            case 2: {
                action = new /* Unavailable Anonymous Inner Class!! */;
                action.setText(i18n.tr("Adjust &X axis"));
                action.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/adjust_x.png"));
                break;
            }
            case 3: {
                action = new /* Unavailable Anonymous Inner Class!! */;
                action.setText(i18n.tr("Adjust &Y axis"));
                action.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/adjust_y.png"));
            }
        }
        return action;
    }

    public void setShowDeleteAction(boolean showDeleteAction) {
        this.showDeleteAction = showDeleteAction;
    }

    public static boolean showGraphPropertyPages(GraphDefinition settings, Shell parentShell) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("graph", (IPreferencePage)new Graph(settings, false)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new GeneralChart((ChartConfiguration)settings, false)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("source", (IPreferencePage)new DataSources(settings, false)));
        36 dlg = new /* Unavailable Anonymous Inner Class!! */;
        dlg.setBlockOnOpen(true);
        return dlg.open() == 0;
    }
}

