/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.filemanager.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.AgentFileData;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.windows.PopOutViewWindow;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.filemanager.views.AgentFileViewer;
import org.netxms.nxmc.modules.filemanager.widgets.BaseFileViewer;
import org.netxms.nxmc.modules.filemanager.widgets.DynamicFileViewer;
import org.netxms.nxmc.modules.objects.views.AdHocObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class AgentFileViewer
extends AdHocObjectView {
    private static final I18n i18n = LocalizationHelper.getI18n(AgentFileViewer.class);
    public static final String ID = "org.netxms.ui.eclipse.filemanager.views.AgentFileViewer";
    private DynamicFileViewer viewer;
    private String remoteFileName;
    private boolean followChanges;
    private Action actionClear;
    private Action actionScrollLock;
    private Action actionCopy;
    private Action actionSelectAll;
    private Action actionFind;

    public AgentFileViewer(long objectId, AgentFileData file, boolean followChanges) {
        super(i18n.tr("Remote File"), ResourceManager.getImageDescriptor((String)"icons/object-views/file-view.png"), file.getRemoteName(), objectId, false);
        this.remoteFileName = file.getRemoteName();
        this.followChanges = followChanges;
        this.setName(this.remoteFileName);
    }

    public View cloneView() {
        AgentFileViewer view = (AgentFileViewer)super.cloneView();
        this.remoteFileName = view.remoteFileName;
        this.followChanges = view.followChanges;
        return view;
    }

    protected void createContent(Composite parent) {
        this.viewer = new DynamicFileViewer(parent, 0, (View)this);
        this.viewer.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
    }

    private void createActions() {
        this.actionClear = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("Ctrl+L", (IAction)this.actionClear);
        this.actionScrollLock = new /* Unavailable Anonymous Inner Class!! */;
        this.actionScrollLock.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/scroll-lock.png"));
        this.actionScrollLock.setChecked(false);
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopy.setEnabled(false);
        this.actionCopy.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.copy");
        this.addKeyBinding("Ctrl+C", (IAction)this.actionCopy);
        this.actionSelectAll = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("Ctrl+A", (IAction)this.actionSelectAll);
        this.actionFind = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("Ctrl+F", (IAction)this.actionFind);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionFind);
        if (this.followChanges) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionClear);
            manager.add((IAction)this.actionScrollLock);
        }
        manager.add((IContributionItem)new Separator());
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getTextControl());
        this.viewer.getTextControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionFind);
        if (this.followChanges) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionClear);
            manager.add((IAction)this.actionScrollLock);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAll);
        manager.add((IAction)this.actionCopy);
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    public static boolean createView(View view, long nodeId, AgentFileData file, boolean followChanges) {
        return AgentFileViewer.createView((View)view, (long)nodeId, (AgentFileData)file, (boolean)followChanges, (boolean)false, null);
    }

    public static boolean createView(View view, long nodeId, AgentFileData file, boolean followChanges, boolean ignoreContext, BaseFileViewer.LineStyler lineStyler) {
        boolean exceedSize;
        boolean bl = exceedSize = file.getFile().length() > 0x4000000L;
        if (exceedSize && !MessageDialogHelper.openConfirm((Shell)view.getWindow().getShell(), (String)i18n.tr("File is too large"), (String)i18n.tr("File is too large to be displayed in full. Click OK to see beginning of the file."))) {
            if (followChanges) {
                NXCSession session = Registry.getSession();
                8 job = new /* Unavailable Anonymous Inner Class!! */;
                job.setUser(false);
                job.setSystem(true);
                job.start();
            }
            return false;
        }
        Perspective p = view.getPerspective();
        AgentFileViewer fileView = new AgentFileViewer(nodeId, file, followChanges);
        if (p != null) {
            p.addMainView((View)fileView, true, ignoreContext);
        } else {
            PopOutViewWindow window = new PopOutViewWindow((View)fileView);
            window.open();
        }
        fileView.viewer.setLineStyler(lineStyler);
        fileView.viewer.showFile(file.getFile(), followChanges);
        if (followChanges) {
            fileView.viewer.startTracking(file.getMonitorId(), nodeId, file.getRemoteName());
        }
        fileView.setName(file.getRemoteName());
        return true;
    }
}

