/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer.views;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.PerspectiveConfiguration;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logviewer.views.LogViewer;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.services.ServerLogDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class LogViewerPerspective
extends Perspective {
    private static final Logger logger = LoggerFactory.getLogger(LogViewerPerspective.class);
    private static final I18n i18n = LocalizationHelper.getI18n(LogViewerPerspective.class);
    private List<ServerLogDescriptor> logs = new ArrayList();

    public LogViewerPerspective() {
        super("Logs", i18n.tr("Logs"), ResourceManager.getImage((String)"icons/perspective-logs.png"));
        this.registerStandardLogViewer(i18n.tr("Audit"), "AuditLog");
        this.registerStandardLogViewer(i18n.tr("Events"), "EventLog");
        this.registerStandardLogViewer(i18n.tr("Maintenance Journal"), "MaintenanceJournal");
        this.registerStandardLogViewer(i18n.tr("Notifications"), "NotificationLog");
        this.registerStandardLogViewer(i18n.tr("Server Action Executions"), "ServerActionExecutionLog");
        this.registerStandardLogViewer(i18n.tr("SNMP Traps"), "SnmpTrapLog");
        this.registerStandardLogViewer(i18n.tr("Syslog"), "syslog");
        this.registerStandardLogViewer(i18n.tr("Windows Events"), "WindowsEventLog");
        ServiceLoader<ServerLogDescriptor> loader = ServiceLoader.load(ServerLogDescriptor.class, this.getClass().getClassLoader());
        for (ServerLogDescriptor e : loader) {
            this.logs.add(e);
        }
        this.logs.sort((l1, l2) -> l1.getDisplayName().compareToIgnoreCase(l2.getDisplayName()));
    }

    private void registerStandardLogViewer(String displayName, String logName) {
        this.logs.add(new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void configurePerspective(PerspectiveConfiguration configuration) {
        super.configurePerspective(configuration);
        configuration.hasNavigationArea = false;
        configuration.multiViewMainArea = true;
        configuration.hasSupplementalArea = false;
        configuration.priority = 155;
    }

    protected void configureViews() {
        NXCSession session = Registry.getSession();
        for (ServerLogDescriptor log : this.logs) {
            String componentId = log.getRequiredComponentId();
            if (componentId == null || session.isServerComponentRegistered(componentId)) {
                LogViewer view = log.createView();
                this.addMainView((View)view);
                logger.debug("Added logs perspective view \"" + view.getName() + "\"");
                continue;
            }
            logger.debug("Logs perspective view \"" + log.getDisplayName() + "\" blocked by component filter");
        }
    }
}

