/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer.widgets;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.constants.ColumnFilterType;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logviewer.widgets.ConditionEditor;
import org.netxms.nxmc.modules.logviewer.widgets.ObjectConditionEditor;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.xnap.commons.i18n.I18n;

public class ObjectConditionEditor
extends ConditionEditor {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectConditionEditor.class);
    private final String[] OPERATIONS = new String[]{this.i18n.tr("IS"), this.i18n.tr("IS NOT"), this.i18n.tr("WITHIN"), this.i18n.tr("NOT WITHIN")};
    private ObjectSelector objectSelector;

    public ObjectConditionEditor(Composite parent) {
        super(parent);
    }

    protected String[] getOperations() {
        return this.OPERATIONS;
    }

    protected void createContent(ColumnFilter initialFilter) {
        this.objectSelector = new ObjectSelector((Composite)this, 0, 2);
        this.objectSelector.setObjectClass(AbstractObject.class);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 0x1000000;
        this.objectSelector.setLayoutData((Object)gd);
        if (initialFilter != null) {
            switch (1.$SwitchMap$org$netxms$client$constants$ColumnFilterType[initialFilter.getType().ordinal()]) {
                case 1: {
                    this.setSelectedOperation(initialFilter.isNegated() ? 1 : 0);
                    this.objectSelector.setObjectId(initialFilter.getNumericValue());
                    break;
                }
                case 2: {
                    this.setSelectedOperation(initialFilter.isNegated() ? 3 : 2);
                    this.objectSelector.setObjectId(initialFilter.getNumericValue());
                    break;
                }
            }
        }
    }

    public ColumnFilter createFilter() {
        int op = this.getSelectedOperation();
        ColumnFilter filter = new ColumnFilter(op == 2 || op == 3 ? ColumnFilterType.CHILDOF : ColumnFilterType.EQUALS, this.objectSelector.getObjectId());
        filter.setNegated(op == 1 || op == 3);
        return filter;
    }
}

