/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.nxsl.views;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.Script;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.TextConsole;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.nxsl.dialogs.CreateScriptDialog;
import org.netxms.nxmc.modules.nxsl.dialogs.SaveScriptDialog;
import org.netxms.nxmc.modules.nxsl.views.ScriptExecutorView;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.modules.objects.views.AdHocObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ScriptExecutorView
extends AdHocObjectView {
    private static final I18n i18n = LocalizationHelper.getI18n(ScriptExecutorView.class);
    private Label scriptName;
    private Combo scriptCombo;
    private ScriptEditor scriptEditor;
    private Text parametersField;
    private TextConsole output;
    private TextConsole.IOConsoleOutputStream consoleOutputStream;
    private Action actionSave;
    private Action actionSaveAs;
    private Action actionClear;
    private Action actionClearOutput;
    private Action actionExecute;
    private List<Script> library;
    private int previousSelection = -1;
    private boolean modified = false;

    public ScriptExecutorView(long objectId) {
        super(i18n.tr("Execute Script"), ResourceManager.getImageDescriptor((String)"icons/object-views/script-executor.png"), "ScriptExecutor", objectId, false);
    }

    protected ScriptExecutorView() {
        super(null, null, null, 0L, false);
    }

    protected void postClone(View origin) {
        super.postClone(origin);
        ScriptExecutorView view = (ScriptExecutorView)origin;
        this.scriptName.setText(view.scriptName.getText());
        this.parametersField.setText(view.parametersField.getText());
        this.output.setText(view.output.getText());
        1 run = new /* Unavailable Anonymous Inner Class!! */;
        this.updateScriptList((Runnable)run);
    }

    public void createContent(Composite parent) {
        Composite formContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 8;
        formContainer.setLayout((Layout)layout);
        this.scriptName = new Label(formContainer, 16384);
        this.scriptName.setFont(JFaceResources.getBannerFont());
        this.scriptName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.scriptName.setText(i18n.tr("Noname"));
        this.scriptCombo = WidgetHelper.createLabeledCombo((Composite)formContainer, (int)8, (String)i18n.tr("Script from library"), (Object)"WidgetHelper::default_layout_data");
        this.scriptCombo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        SashForm splitter = new SashForm(formContainer, 512);
        splitter.setSashWidth(3);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        splitter.setLayoutData((Object)gridData);
        Composite container = new Composite((Composite)splitter, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 4;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 16384);
        label.setText(i18n.tr("Parameters (comma-separated list)"));
        this.parametersField = new Text(container, 2052);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.parametersField.setLayoutData((Object)gridData);
        label = new Label(container, 16384);
        label.setText(i18n.tr("Source"));
        this.scriptEditor = new ScriptEditor(container, 2048, 768, true);
        this.scriptEditor.setText("");
        this.scriptEditor.getTextWidget().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.scriptEditor.setLayoutData((Object)gridData);
        container = new Composite((Composite)splitter, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        container.setLayout((Layout)layout);
        label = new Label(container, 16384);
        label.setText(i18n.tr("Output"));
        this.output = new TextConsole(container, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.output.setLayoutData((Object)gridData);
        this.createActions();
        this.actionSave.setEnabled(false);
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.updateScriptList(null);
    }

    private void onTextModify() {
        if (!this.modified) {
            this.modified = true;
            if (this.scriptCombo.getSelectionIndex() != -1) {
                this.actionSave.setEnabled(true);
            }
        }
    }

    public void setFocus() {
        this.scriptEditor.setFocus();
    }

    private void createActions() {
        this.actionSave = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+S", (IAction)this.actionSave);
        this.actionSaveAs = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+M2+S", (IAction)this.actionSaveAs);
        this.actionClear = new /* Unavailable Anonymous Inner Class!! */;
        this.actionClearOutput = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+L", (IAction)this.actionClearOutput);
        this.actionExecute = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("F9", (IAction)this.actionExecute);
    }

    public void refresh() {
        if (this.modified && this.saveIfRequired(false)) {
            return;
        }
        this.updateScriptList(null);
        this.getScriptContent();
        this.output.clear();
    }

    public boolean beforeClose() {
        if (!this.modified) {
            return true;
        }
        SaveScriptDialog dlg = new SaveScriptDialog(this.getWindow().getShell(), this.actionSave.isEnabled());
        int rc = dlg.open();
        switch (rc) {
            case 100: {
                this.saveScript(false, true);
                break;
            }
            case 101: {
                this.createNewScript(false, true);
                break;
            }
            case 102: {
                this.getScriptContent();
                this.clearModificationFlag();
                break;
            }
            default: {
                this.scriptCombo.select(this.previousSelection);
            }
        }
        return rc != 1;
    }

    private boolean saveIfRequired(boolean onSelectionChange) {
        SaveScriptDialog dlg = new SaveScriptDialog(this.getWindow().getShell(), this.actionSave.isEnabled());
        int rc = dlg.open();
        switch (rc) {
            case 100: {
                this.saveScript(onSelectionChange, false);
                break;
            }
            case 101: {
                this.createNewScript(onSelectionChange, false);
                break;
            }
            case 102: {
                this.getScriptContent();
                this.clearModificationFlag();
                break;
            }
            default: {
                this.scriptCombo.select(this.previousSelection);
            }
        }
        return rc == 1;
    }

    private boolean createNewScript(boolean saveOnSelectionChange, boolean saveOnClose) {
        CreateScriptDialog dlg = new CreateScriptDialog(this.getWindow().getShell(), null);
        if (dlg.open() != 0) {
            return false;
        }
        String scriptSource = this.scriptEditor.getText();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void getScriptContent() {
        int index = this.scriptCombo.getSelectionIndex();
        if (index == -1) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void executeScript() {
        String script = this.scriptEditor.getText();
        String parameters = this.parametersField.getText();
        this.consoleOutputStream = this.output.newOutputStream();
        this.actionExecute.setEnabled(false);
        11 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void updateScriptList(Runnable postProcessor) {
        String selection = this.scriptCombo.getSelectionIndex() != -1 ? this.scriptCombo.getItem(this.scriptCombo.getSelectionIndex()) : null;
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void saveScript(boolean saveOnSelectionChange, boolean saveOnClose) {
        Script s = (Script)this.library.get(saveOnSelectionChange ? this.previousSelection : this.scriptCombo.getSelectionIndex());
        String scriptSource = this.scriptEditor.getText();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void clearModificationFlag() {
        this.modified = false;
        this.actionSave.setEnabled(false);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExecute);
        manager.add((IAction)this.actionClearOutput);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionSaveAs);
        manager.add((IAction)this.actionClear);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExecute);
        manager.add((IAction)this.actionClearOutput);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionSaveAs);
        manager.add((IAction)this.actionClear);
    }

    static /* synthetic */ NXCSession access$000(ScriptExecutorView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$100(ScriptExecutorView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$200(ScriptExecutorView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$300(ScriptExecutorView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$400(ScriptExecutorView x0) {
        return x0.session;
    }
}

