/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.actions.ViewerProvider;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.HardwareInventoryView;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.widgets.HardwareInventory;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class HardwareInventoryView
extends ObjectView {
    private static final I18n i18n = LocalizationHelper.getI18n(HardwareInventoryView.class);
    public static final String ID = "org.netxms.ui.eclipse.objectview.views.HardwareInventoryView";
    private HardwareInventory inventoryWidget;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;

    public HardwareInventoryView() {
        super(i18n.tr("Hardware Inventory"), ResourceManager.getImageDescriptor((String)"icons/object-views/components.png"), "HardwareInventory", false);
    }

    protected void createContent(Composite parent) {
        this.inventoryWidget = new HardwareInventory(parent, 0, (View)this, "HardwareInventoryView");
        this.createActions();
        this.createPopupMenu();
    }

    private void createActions() {
        1 vp = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ViewerProvider)vp, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ViewerProvider)vp, false);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        this.inventoryWidget.setViewerMenu(menuMgr);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IAction)this.actionExportAllToCsv);
    }

    public void refresh() {
        this.inventoryWidget.refresh();
    }

    protected void onObjectChange(AbstractObject object) {
        this.clearMessages();
        this.inventoryWidget.clear();
        if (object == null) {
            return;
        }
        this.inventoryWidget.setRootObjectId(object.getObjectId());
        this.inventoryWidget.refresh();
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Node && ((Node)context).hasAgent();
    }

    public int getPriority() {
        return 60;
    }
}

