/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Rack;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContextMenuManager;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.RackView;
import org.netxms.nxmc.modules.objects.widgets.RackWidget;
import org.netxms.nxmc.modules.objects.widgets.helpers.ElementSelectionListener;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class RackView
extends ObjectView
implements ISelectionProvider {
    private static I18n i18n = LocalizationHelper.getI18n(RackView.class);
    private ScrolledComposite scroller;
    private Composite content;
    private RackWidget rackFrontWidget;
    private RackWidget rackRearWidget;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet();

    public RackView() {
        super(i18n.tr("Rack"), ResourceManager.getImageDescriptor((String)"icons/object-views/rack.gif"), "Rack", false);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Rack;
    }

    public int getPriority() {
        return 15;
    }

    protected void createContent(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 256);
        this.content = new /* Unavailable Anonymous Inner Class!! */;
        this.content.setBackground(ThemeEngine.getBackgroundColor((String)"Rack"));
        this.content.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.scroller.setContent((Control)this.content);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
        this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void updateRackWidgetsSize() {
        int height = this.content.getSize().y;
        Point size = this.rackFrontWidget.computeSize(-1, height, true);
        this.rackFrontWidget.setSize(size);
        this.rackRearWidget.setSize(size);
        this.rackRearWidget.setLocation(size.x, 0);
    }

    private void createPopupMenu() {
        ObjectContextMenuManager menuMgr = new ObjectContextMenuManager((View)this, (ISelectionProvider)this, null);
        Menu menu = menuMgr.createContextMenu((Control)this.rackFrontWidget);
        this.rackFrontWidget.setMenu(menu);
        menu = menuMgr.createContextMenu((Control)this.rackRearWidget);
        this.rackRearWidget.setMenu(menu);
    }

    protected void onObjectChange(AbstractObject object) {
        if (this.rackFrontWidget != null) {
            this.rackFrontWidget.dispose();
            this.rackFrontWidget = null;
        }
        if (this.rackRearWidget != null) {
            this.rackRearWidget.dispose();
            this.rackRearWidget = null;
        }
        if (object != null) {
            4 listener = new /* Unavailable Anonymous Inner Class!! */;
            this.rackFrontWidget = new RackWidget(this.content, 0, (Rack)object, RackOrientation.FRONT, (View)this);
            this.rackFrontWidget.addSelectionListener((ElementSelectionListener)listener);
            this.rackRearWidget = new RackWidget(this.content, 0, (Rack)object, RackOrientation.REAR, (View)this);
            this.rackRearWidget.addSelectionListener((ElementSelectionListener)listener);
            this.scroller.setMinSize(this.content.computeSize(-1, this.scroller.getSize().y));
            this.updateRackWidgetsSize();
            this.createPopupMenu();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

