/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.JavaScriptExecutor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.objects.AbstractNode;
import org.netxms.nxmc.DownloadServiceHandler;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.AdHocObjectView;
import org.netxms.nxmc.modules.objects.views.ScreenshotView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ScreenshotView
extends AdHocObjectView {
    private static final I18n i18n = LocalizationHelper.getI18n(ScreenshotView.class);
    private String userSession;
    private String userName;
    private Image image;
    private String errorMessage;
    private String imageInfo;
    private ScrolledComposite scroller;
    private Canvas canvas;
    private byte[] byteImage;
    private Action actionAutoRefresh;
    private Action actionSave;
    private boolean autoRefresh = false;
    private long lastRequestTime;

    public ScreenshotView(AbstractNode node, String userSession, String userName) {
        super(i18n.tr("Screenshot"), ResourceManager.getImageDescriptor((String)"icons/screenshot.png"), "Screenshot", node.getObjectId(), false);
        this.userSession = userSession;
        this.userName = userName;
    }

    protected ScreenshotView() {
        super(null, null, null, 0L, false);
    }

    public View cloneView() {
        ScreenshotView view = (ScreenshotView)super.cloneView();
        this.userSession = view.userSession;
        this.userName = view.userName;
        this.image = view.image;
        this.errorMessage = view.errorMessage;
        this.imageInfo = view.imageInfo;
        this.lastRequestTime = view.lastRequestTime;
        return view;
    }

    protected void postClone(View origin) {
        this.canvas.redraw();
    }

    public void createContent(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.scroller = new ScrolledComposite(parent, 768);
        this.canvas = new Canvas((Composite)this.scroller, 0);
        this.canvas.addPaintListener((PaintListener)new /* Unavailable Anonymous Inner Class!! */);
        this.scroller.setContent((Control)this.canvas);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
        this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
    }

    public void activate() {
        super.activate();
        this.refresh();
    }

    private void updateScrollerSize() {
        if (this.image != null) {
            ImageData d = this.image.getImageData();
            Point pt = WidgetHelper.getTextExtent((Control)this.canvas, (String)this.imageInfo);
            this.scroller.setMinSize(new Point(Math.max(d.width, pt.x + 20), d.height + pt.y + 15));
        } else if (this.errorMessage != null) {
            Point pt = WidgetHelper.getTextExtent((Control)this.canvas, (String)this.errorMessage);
            this.scroller.setMinSize(new Point(pt.x + 20, pt.y + 20));
        } else {
            this.scroller.setMinSize(new Point(0, 0));
        }
    }

    public void refresh() {
        3 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void createActions() {
        this.actionAutoRefresh = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAutoRefresh.setChecked(this.autoRefresh);
        this.actionSave = new /* Unavailable Anonymous Inner Class!! */;
        this.actionSave.setEnabled(false);
        this.addKeyBinding("M1+S", (IAction)this.actionSave);
    }

    private void saveImage() {
        String id = Long.toString(System.currentTimeMillis());
        DownloadServiceHandler.addDownload((String)id, (String)(this.getObjectName() + "-screenshot-" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + ".png"), (byte[])this.byteImage, (String)"application/octet-stream");
        JavaScriptExecutor executor = (JavaScriptExecutor)RWT.getClient().getService(JavaScriptExecutor.class);
        if (executor != null) {
            StringBuilder js = new StringBuilder();
            js.append("var hiddenIFrameID = 'hiddenDownloader',");
            js.append("   iframe = document.getElementById(hiddenIFrameID);");
            js.append("if (iframe === null) {");
            js.append("   iframe = document.createElement('iframe');");
            js.append("   iframe.id = hiddenIFrameID;");
            js.append("   iframe.style.display = 'none';");
            js.append("   document.body.appendChild(iframe);");
            js.append("}");
            js.append("iframe.src = '");
            js.append(DownloadServiceHandler.createDownloadUrl((String)id));
            js.append("';");
            executor.execute(js.toString());
        }
    }

    public void setFocus() {
        this.canvas.setFocus();
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAutoRefresh);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
    }
}

