/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.VlanInfo;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.base.windows.PopOutViewWindow;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.networkmaps.views.VlanMap;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.helpers.VlanLabelProvider;
import org.netxms.nxmc.modules.objects.widgets.DeviceViewWidget;
import org.netxms.nxmc.modules.objects.widgets.helpers.PortSelectionListener;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class VlanView
extends ObjectView {
    private static final I18n i18n = LocalizationHelper.getI18n(VlanView.class);
    public static final int COLUMN_VLAN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_PORTS = 2;
    public static final int COLUMN_INTERFACES = 3;
    private List<VlanInfo> vlans = new ArrayList(0);
    private NXCSession session = Registry.getSession();
    private SortableTableViewer vlanList;
    private ScrolledComposite scroller;
    private DeviceViewWidget deviceView;
    private boolean objectsFullySync;
    private Action actionShowVlanMap;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;

    public VlanView() {
        super(i18n.tr("VLANs"), ResourceManager.getImageDescriptor((String)"icons/object-views/vlans.gif"), "VLANView", false);
        PreferenceStore store = PreferenceStore.getInstance();
        this.objectsFullySync = store.getAsBoolean("ObjectBrowser.FullSync", false);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Node && ((Node)context).isBridge();
    }

    public int getPriority() {
        return 160;
    }

    protected void createContent(Composite parent) {
        SashForm splitter = new SashForm(parent, 512);
        splitter.setSashWidth(3);
        Composite vlanListArea = new Composite((Composite)splitter, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        vlanListArea.setLayout((Layout)layout);
        String[] names = new String[]{i18n.tr("ID"), i18n.tr("Name"), i18n.tr("Ports"), "Interfaces"};
        int[] widths = new int[]{80, 180, 400, 400};
        this.vlanList = new SortableTableViewer(vlanListArea, names, widths, 0, 1024, 65538);
        this.vlanList.setContentProvider((IContentProvider)new ArrayContentProvider());
        VlanLabelProvider labelProvider = new VlanLabelProvider();
        this.vlanList.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.vlanList.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.vlanList.setInput((Object)this.vlans.toArray());
        this.vlanList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.vlanList, (String)"VlanList");
        this.vlanList.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        new Label(vlanListArea, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite deviceViewArea = new Composite((Composite)splitter, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        deviceViewArea.setLayout((Layout)layout);
        new Label(deviceViewArea, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.scroller = new ScrolledComposite(deviceViewArea, 768);
        this.scroller.setLayoutData((Object)new GridData(4, 4, true, true));
        this.deviceView = new DeviceViewWidget((Composite)this.scroller, 0);
        this.deviceView.setPortStatusVisible(false);
        this.deviceView.setNodeId(this.getObjectId());
        this.deviceView.addSelectionListener((PortSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.scroller.setContent((Control)this.deviceView);
        this.scroller.setBackground(this.deviceView.getBackground());
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
        this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        splitter.setWeights(new int[]{60, 40});
        this.createActions();
        this.createPopupMenu();
    }

    private void createActions() {
        this.actionShowVlanMap = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.vlanList, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.vlanList, false);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.vlanList.getControl());
        this.vlanList.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionShowVlanMap);
        manager.add((IAction)this.actionExportToCsv);
    }

    public void setVlans(List<VlanInfo> vlans) {
        this.vlans = vlans;
        this.vlanList.setInput((Object)vlans.toArray());
    }

    private void showVlanMap() {
        IStructuredSelection selection = this.vlanList.getStructuredSelection();
        for (Object o : selection.toList()) {
            VlanInfo vlan = (VlanInfo)o;
            VlanMap vlanMap = new VlanMap(this.getObject(), vlan.getVlanId());
            if (this.getPerspective() != null) {
                this.getPerspective().addMainView((View)vlanMap, true, false);
                continue;
            }
            PopOutViewWindow window = new PopOutViewWindow((View)vlanMap);
            window.open();
        }
    }

    public void refresh() {
        String objectName = this.session.getObjectName(this.getObjectId());
        boolean syncChildren = !this.objectsFullySync && !this.session.areChildrenSynchronized(this.getObjectId());
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void onObjectChange(AbstractObject object) {
        this.setVlans(new ArrayList());
        if (object != null) {
            this.deviceView.setNodeId(object.getObjectId());
            this.refresh();
        }
    }
}

