/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.CommandBox;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContext;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.Commands;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.netxms.nxmc.modules.objecttools.ObjectToolExecutor;
import org.netxms.nxmc.modules.objecttools.ObjectToolsCache;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class Commands
extends OverviewPageElement {
    private I18n i18n = LocalizationHelper.getI18n(Commands.class);
    private CommandBox commandBox;
    private Action actionWakeup;

    public Commands(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        super(parent, anchor, objectView);
        this.createActions();
    }

    private void createActions() {
        NXCSession session = Registry.getSession();
        this.actionWakeup = new /* Unavailable Anonymous Inner Class!! */;
        this.actionWakeup.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/wake-on-lan.png"));
    }

    protected String getTitle() {
        return this.i18n.tr("Commands");
    }

    protected void onObjectChange() {
        this.commandBox.deleteAll(false);
        if (this.getObject() instanceof AbstractNode) {
            ObjectTool[] tools;
            for (ObjectTool tool : tools = ObjectToolsCache.getInstance().getTools()) {
                if (!tool.isVisibleInCommands() || !tool.isEnabled() || !tool.isApplicableForObject(this.getObject())) continue;
                HashSet<ObjectContext> nodes = new HashSet<ObjectContext>(1);
                nodes.add(new ObjectContext((AbstractObject)((AbstractNode)this.getObject()), null));
                if (!ObjectToolExecutor.isToolAllowed((ObjectTool)tool, nodes)) continue;
                2 action = new /* Unavailable Anonymous Inner Class!! */;
                ImageDescriptor icon = ObjectToolsCache.getInstance().findIcon(tool.getId());
                if (icon != null) {
                    action.setImageDescriptor(icon);
                }
                this.commandBox.add((Action)action, false);
            }
        } else if (this.getObject() instanceof Interface) {
            this.commandBox.add(this.actionWakeup, false);
        }
        this.commandBox.rebuild();
    }

    protected Control createClientArea(Composite parent) {
        this.commandBox = new CommandBox(parent, 0);
        return this.commandBox;
    }

    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof Node || object instanceof Interface;
    }
}

