/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objecttools.views;

import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.TableContentProvider;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.TableItemComparator;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.TableLabelProvider;
import org.netxms.nxmc.modules.objects.ObjectContext;
import org.netxms.nxmc.modules.objecttools.views.ObjectToolResultView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class TableToolResults
extends ObjectToolResultView {
    private static final I18n i18n = LocalizationHelper.getI18n(TableToolResults.class);
    private SortableTableViewer viewer;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;

    public TableToolResults(ObjectContext node, ObjectTool tool) {
        super(node, tool, ResourceManager.getImageDescriptor((String)"icons/object-tools/table.gif"), false);
    }

    protected void createContent(Composite parent) {
        this.viewer = new SortableTableViewer(parent, 65538);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.createActions();
        this.createPopupMenu();
        this.refreshTable();
    }

    private void createActions() {
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, false);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportToCsv);
    }

    public void refreshTable() {
        this.viewer.setInput(null);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void updateViewer(Table table) {
        if (!this.viewer.isInitialized()) {
            String[] names = table.getColumnDisplayNames();
            int[] widths = new int[names.length];
            Arrays.fill(widths, 100);
            this.viewer.createColumns(names, widths, 0, 128);
            WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)("TableToolResults." + Long.toString(this.tool.getId())));
            this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
            this.viewer.setComparator((ViewerComparator)new TableItemComparator(table.getColumnDataTypes()));
        }
        ((TableLabelProvider)this.viewer.getLabelProvider()).setColumns(table.getColumns());
        this.viewer.setInput((Object)table);
    }

    static /* synthetic */ NXCSession access$000(TableToolResults x0) {
        return x0.session;
    }
}

