/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.SshKeyPair;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class SSHKeyEditDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(SSHKeyEditDialog.class);
    private LabeledText textName;
    private LabeledText publicKey;
    private LabeledText privateKey;
    private Button replaceKeysButton;
    private SshKeyPair key;
    private boolean isNew;

    public SSHKeyEditDialog(Shell shell, SshKeyPair key) {
        super(shell);
        if (key == null) {
            this.key = new SshKeyPair();
            this.isNew = true;
        } else {
            this.key = key;
            this.isNew = false;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.textName = new LabeledText(dialogArea, 0);
        this.textName.setLabel(this.i18n.tr("Name"));
        this.textName.setText(this.key.getName());
        this.textName.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.textName.setLayoutData((Object)gd);
        if (!this.isNew) {
            this.replaceKeysButton = new Button(dialogArea, 32);
            this.replaceKeysButton.setText(this.i18n.tr("Replace keys"));
            this.replaceKeysButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.publicKey = new LabeledText(dialogArea, 0, 2626);
        this.publicKey.setLabel(this.i18n.tr("Public key"));
        this.publicKey.setText(this.key.getPublicKey());
        this.publicKey.setEditable(this.isNew);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.heightHint = 200;
        gd.widthHint = 600;
        gd.verticalAlignment = 4;
        this.publicKey.setLayoutData((Object)gd);
        this.privateKey = new LabeledText(dialogArea, 0, 2626);
        this.privateKey.setLabel(this.i18n.tr("Private key"));
        this.privateKey.setText("");
        this.privateKey.setEditable(this.isNew);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.heightHint = 200;
        gd.widthHint = 600;
        gd.verticalAlignment = 4;
        this.privateKey.setLayoutData((Object)gd);
        return dialogArea;
    }

    public SshKeyPair getSshKeyData() {
        return this.key;
    }

    protected void okPressed() {
        if (this.textName.getText().isEmpty() || (this.isNew || this.replaceKeysButton.getSelection()) && (this.publicKey.getText().isEmpty() || this.privateKey.getText().isEmpty())) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("All fields should be filled"));
            return;
        }
        this.key.setName(this.textName.getText());
        if (this.isNew || this.replaceKeysButton.getSelection()) {
            this.key.setKeys(this.publicKey.getText(), this.privateKey.getText());
        }
        super.okPressed();
    }
}

