/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.objecttabs.NodeComponentTab;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.NodeComponentTabFilter;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public abstract class NodeComponentViewerTab
extends NodeComponentTab {
    protected SortableTableViewer viewer;
    protected Action actionCopyToClipboard;
    protected Action actionExportToCsv;
    protected boolean showFilter = true;
    protected FilterText filterText;
    protected NodeComponentTabFilter filter;

    @Override
    protected void createTabContent(Composite parent) {
        super.createTabContent(parent);
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.showFilter = NodeComponentViewerTab.safeCast(settings.get(this.getFilterSettingName()), settings.getBoolean(this.getFilterSettingName()), this.showFilter);
        this.filterText = new FilterText(this.mainArea, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NodeComponentViewerTab.this.onFilterModify();
            }
        });
        this.filterText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                settings.put(NodeComponentViewerTab.this.getFilterSettingName(), NodeComponentViewerTab.this.showFilter);
            }
        });
        Action action = new Action(){

            public void run() {
                NodeComponentViewerTab.this.enableFilter(false);
                ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = service.getCommand("org.netxms.ui.eclipse.objectview.commands.show_filter");
                State state = command.getState("org.netxms.ui.eclipse.objectview.commands.show_filter.state");
                state.setValue((Object)false);
                service.refreshElements(command.getId(), null);
            }
        };
        this.setFilterCloseAction(action);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.createViewer();
        this.createActions();
        this.createPopupMenu();
        if (this.showFilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
    }

    protected FilterText createFilterText() {
        return new FilterText(this.mainArea, 0);
    }

    protected abstract void createViewer();

    public abstract String getFilterSettingName();

    @Override
    public void selected() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("org.netxms.ui.eclipse.objectview.commands.show_filter");
        State state = command.getState("org.netxms.ui.eclipse.objectview.commands.show_filter.state");
        state.setValue((Object)this.showFilter);
        service.refreshElements(command.getId(), null);
        super.selected();
    }

    protected static boolean safeCast(String s, boolean b, boolean defval) {
        return s != null ? b : defval;
    }

    private void setFilterCloseAction(Action action) {
        this.filterText.setCloseAction(action);
    }

    public void enableFilter(boolean enable) {
        this.showFilter = enable;
        this.filterText.setVisible(this.showFilter);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText, 0, 1024) : new FormAttachment(0, 0);
        this.mainArea.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
    }

    public void onFilterModify() {
        if (this.filter == null) {
            return;
        }
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    protected void createActions() {
        this.actionCopyToClipboard = new Action("Copy to clipboard", SharedIcons.COPY){

            public void run() {
                NodeComponentViewerTab.this.copyToClipboard(-1);
            }
        };
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this.getViewPart(), (ColumnViewer)this.viewer, true);
    }

    protected void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NodeComponentViewerTab.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        if (this.getViewPart() != null) {
            this.getViewPart().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        }
    }

    protected abstract void fillContextMenu(IMenuManager var1);

    @Override
    public void currentObjectUpdated(AbstractObject object) {
        this.objectChanged(object);
    }

    @Override
    public boolean showForObject(AbstractObject object) {
        return object instanceof AbstractNode;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.viewer;
    }

    protected void copyToClipboard(int column) {
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length > 0) {
            String newLine = WidgetHelper.getNewLineCharacters();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < selection.length) {
                if (i > 0) {
                    sb.append(newLine);
                }
                if (column == -1) {
                    int j = 0;
                    while (j < this.viewer.getTable().getColumnCount()) {
                        if (j > 0) {
                            sb.append('\t');
                        }
                        sb.append(selection[i].getText(j));
                        ++j;
                    }
                } else {
                    sb.append(selection[i].getText(column));
                }
                ++i;
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }
}

