/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HttpRequestMethod {
    GET(0),
    POST(1),
    PUT(2),
    DELETE(3),
    PATCH(4);

    private static Logger logger;
    private static Map<Integer, HttpRequestMethod> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(HttpRequestMethod.class);
        lookupTable = new HashMap<Integer, HttpRequestMethod>();
        HttpRequestMethod[] httpRequestMethodArray = HttpRequestMethod.values();
        int n = httpRequestMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            HttpRequestMethod element = httpRequestMethodArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private HttpRequestMethod(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static HttpRequestMethod getByValue(int value) {
        HttpRequestMethod element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return GET;
        }
        return element;
    }
}

