/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.dialogs;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.NXCommon;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.EventReferenceType;
import org.netxms.client.events.EventReference;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class EventReferenceViewDialog
extends Dialog {
    private static final int COLUMN_TYPE = 0;
    private static final int COLUMN_ID = 1;
    private static final int COLUMN_NAME = 2;
    private static final int COLUMN_DESCRIPTION = 3;
    private static final int COLUMN_OWNER_ID = 4;
    private static final int COLUMN_OWNER_NAME = 5;
    private NXCSession session = ConsoleSharedData.getSession();
    private List<EventReference> references;
    private SortableTableViewer viewer;
    private String eventName;
    private boolean showWarning;
    private boolean multiChoice;

    public EventReferenceViewDialog(Shell parentShell, String eventName, List<EventReference> references, boolean showWarning, boolean multiChoice) {
        super(parentShell);
        this.references = references;
        this.eventName = eventName;
        this.showWarning = showWarning;
        this.multiChoice = multiChoice;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.showWarning ? "Warning" : String.format("Event References - %s", this.eventName));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.showWarning) {
            if (this.multiChoice) {
                this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
                this.createButton(parent, 4, IDialogConstants.YES_TO_ALL_LABEL, false);
                this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
                this.createButton(parent, 21, IDialogConstants.NO_TO_ALL_LABEL, false);
            } else {
                this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
                this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
            }
        } else {
            this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
        }
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        if (this.showWarning) {
            Composite warningArea = new Composite(dialogArea, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 4;
            layout.numColumns = 2;
            warningArea.setLayout((Layout)layout);
            Label label = new Label(warningArea, 0);
            label.setImage(parent.getDisplay().getSystemImage(8));
            label = new Label(warningArea, 16384);
            label.setText(String.format("Event %s is used in the following entities. Deleting it may cause unexpected system behavior. Are you sure?", this.eventName));
            label.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        }
        String[] names = new String[]{"Type", "ID", "Name", "Description", "Owner ID", "Owner name"};
        int[] widths = new int[]{150, 100, 200, 200, 100, 200};
        this.viewer = new SortableTableViewer(dialogArea, names, widths, 0, 128, 67584);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ReferenceLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ReferenceComparator());
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 400;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setInput(this.references);
        this.viewer.packColumns();
        return dialogArea;
    }

    private String getObjectPath(long objectId, String fallbackName) {
        AbstractObject object = this.session.findObjectById(objectId);
        if (object == null) {
            return fallbackName;
        }
        List parents = object.getParentChain(null);
        Collections.reverse(parents);
        StringBuilder sb = new StringBuilder();
        for (AbstractObject parent : parents) {
            sb.append(parent.getObjectName());
            sb.append("/");
        }
        sb.append(object.getObjectName());
        return sb.toString();
    }

    private class ReferenceComparator
    extends ViewerComparator {
        private ReferenceComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int result;
            EventReference r1 = (EventReference)e1;
            EventReference r2 = (EventReference)e2;
            int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
            switch (column) {
                case 0: {
                    result = r1.getType().toString().compareTo(r2.getType().toString());
                    break;
                }
                case 1: {
                    result = this.compareId(r1.getId(), r1.getGuid(), r2.getId(), r2.getGuid());
                    break;
                }
                case 2: {
                    String n1 = r1.getType() == EventReferenceType.CONDITION ? EventReferenceViewDialog.this.getObjectPath(r1.getId(), r1.getName()) : r1.getName();
                    String n2 = r2.getType() == EventReferenceType.CONDITION ? EventReferenceViewDialog.this.getObjectPath(r2.getId(), r2.getName()) : r2.getName();
                    result = n1.compareToIgnoreCase(n2);
                    break;
                }
                case 4: {
                    result = this.compareId(r1.getOwnerId(), r1.getOwnerGuid(), r2.getOwnerId(), r2.getOwnerGuid());
                    break;
                }
                case 5: {
                    String n1 = r1.getType() == EventReferenceType.AGENT_POLICY || r1.getType() == EventReferenceType.DCI ? EventReferenceViewDialog.this.getObjectPath(r1.getOwnerId(), r1.getOwnerName()) : r1.getOwnerName();
                    String n2 = r2.getType() == EventReferenceType.AGENT_POLICY || r2.getType() == EventReferenceType.DCI ? EventReferenceViewDialog.this.getObjectPath(r2.getOwnerId(), r2.getOwnerName()) : r2.getOwnerName();
                    result = n1.compareToIgnoreCase(n2);
                    break;
                }
                case 3: {
                    result = r1.getDescription().compareToIgnoreCase(r2.getDescription());
                    break;
                }
                default: {
                    result = 0;
                }
            }
            return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
        }

        private int compareId(long id1, UUID guid1, long id2, UUID guid2) {
            if (id1 != 0L && id2 != 0L) {
                return Long.signum(id1 - id2);
            }
            if (id1 == 0L && id2 == 0L) {
                return guid1.compareTo(guid2);
            }
            return Long.signum(id2 - id1);
        }
    }

    private class ReferenceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ReferenceLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            EventReference r = (EventReference)element;
            switch (columnIndex) {
                case 0: {
                    return this.getTypeName(r.getType());
                }
                case 1: {
                    return this.getIdText(r.getId(), r.getGuid());
                }
                case 2: {
                    if (r.getType() == EventReferenceType.CONDITION) {
                        return EventReferenceViewDialog.this.getObjectPath(r.getId(), r.getName());
                    }
                    return r.getName();
                }
                case 4: {
                    return this.getIdText(r.getOwnerId(), r.getOwnerGuid());
                }
                case 5: {
                    if (r.getType() == EventReferenceType.AGENT_POLICY || r.getType() == EventReferenceType.DCI) {
                        return EventReferenceViewDialog.this.getObjectPath(r.getOwnerId(), r.getOwnerName());
                    }
                    return r.getOwnerName();
                }
                case 3: {
                    return r.getDescription();
                }
            }
            return null;
        }

        private String getIdText(long id, UUID guid) {
            if (id != 0L) {
                return Long.toString(id);
            }
            if (!guid.equals(NXCommon.EMPTY_GUID)) {
                return guid.toString();
            }
            return null;
        }

        private String getTypeName(EventReferenceType type) {
            switch (type) {
                case AGENT_POLICY: {
                    return "Agent Policy";
                }
                case CONDITION: {
                    return "Condition";
                }
                case DCI: {
                    return "Data Collection Item";
                }
                case EP_RULE: {
                    return "Event Processing Policy";
                }
                case SNMP_TRAP: {
                    return "SNMP Trap";
                }
                case SYSLOG: {
                    return "Syslog Parser";
                }
                case WINDOWS_EVENT_LOG: {
                    return "Windows Event Log Parser";
                }
            }
            return "Error";
        }
    }
}

