/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.views;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.constants.UserAuthenticationMethod;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.usermanager.Activator;
import org.netxms.ui.eclipse.usermanager.Messages;
import org.netxms.ui.eclipse.usermanager.dialogs.ChangePasswordDialog;
import org.netxms.ui.eclipse.usermanager.dialogs.CreateObjectDialog;
import org.netxms.ui.eclipse.usermanager.views.helpers.UserComparator;
import org.netxms.ui.eclipse.usermanager.views.helpers.UserFilter;
import org.netxms.ui.eclipse.usermanager.views.helpers.UserLabelProvider;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class UserManagementView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.usermanager.views.UserManagementView";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_FULLNAME = 2;
    public static final int COLUMN_DESCRIPTION = 3;
    public static final int COLUMN_SOURCE = 4;
    public static final int COLUMN_AUTH_METHOD = 5;
    public static final int COLUMN_GUID = 6;
    public static final int COLUMN_LDAP_DN = 7;
    public static final int COLUMN_LAST_LOGIN = 8;
    public static final int COLUMN_CREATED = 9;
    private TableViewer viewer;
    private NXCSession session;
    private SessionListener sessionListener;
    private boolean editNewUser = false;
    private Action actionAddUser;
    private Action actionAddGroup;
    private Action actionEditUser;
    private Action actionDeleteUser;
    private Action actionChangePassword;
    private Action actionEnable;
    private Action actionDisable;
    private Action actionDetachUserFromLDAP;
    private Action actionShowFilter;
    private RefreshAction actionRefresh;
    private Composite mainArea;
    private UserFilter filter;
    private FilterText filterText;
    private IDialogSettings settings;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        this.settings = Activator.getDefault().getDialogSettings();
    }

    public void createPartControl(Composite parent) {
        this.mainArea = new Composite(parent, 0);
        this.mainArea.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this.mainArea, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UserManagementView.this.onFilterModify();
            }
        });
        String[] stringArray = new String[10];
        Messages.get();
        stringArray[0] = Messages.UserManagementView_Name;
        Messages.get();
        stringArray[1] = Messages.UserManagementView_Type;
        Messages.get();
        stringArray[2] = Messages.UserManagementView_FullName;
        Messages.get();
        stringArray[3] = Messages.UserManagementView_Description;
        Messages.get();
        stringArray[4] = Messages.UserManagementView_Source;
        Messages.get();
        stringArray[5] = Messages.UserManagementView_Authentication;
        Messages.get();
        stringArray[6] = Messages.UserManagementView_GUID;
        stringArray[7] = "LDAP DN";
        stringArray[8] = "Last Login";
        stringArray[9] = "Created";
        String[] names = stringArray;
        int[] widths = new int[]{100, 80, 180, 250, 80, 170, 250, 400, 250, 250};
        this.viewer = new SortableTableViewer(this.mainArea, names, widths, 0, 128, -1);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        UserLabelProvider labelProvider = new UserLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setComparator((ViewerComparator)new UserComparator());
        this.filter = new UserFilter(labelProvider);
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    UserManagementView.this.actionEditUser.setEnabled(selection.size() == 1);
                    UserManagementView.this.actionChangePassword.setEnabled(selection.size() == 1 && selection.getFirstElement() instanceof User);
                    UserManagementView.this.actionDeleteUser.setEnabled(selection.size() > 0);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                UserManagementView.this.actionEditUser.run();
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.makeActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.filterText.setCloseAction(new Action(){

            public void run() {
                UserManagementView.this.enableFilter(false);
                UserManagementView.this.actionShowFilter.setChecked(false);
            }
        });
        if (this.actionShowFilter.isChecked()) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.sessionListener = new SessionListener(){

            public void notificationHandler(final SessionNotification n) {
                if (n.getCode() == 3) {
                    UserManagementView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).UserManagementView.this.viewer.setInput((Object)(this).UserManagementView.this.session.getUserDatabaseObjects());
                            if ((this).UserManagementView.this.editNewUser && n.getSubCode() == 0L) {
                                (this).UserManagementView.this.editNewUser = false;
                                (this).UserManagementView.this.viewer.setSelection((ISelection)new StructuredSelection(n.getObject()), true);
                                (this).UserManagementView.this.actionEditUser.run();
                            }
                        }
                    });
                }
            }
        };
        this.session.addListener(this.sessionListener);
        this.viewer.setInput((Object)this.session.getUserDatabaseObjects());
        this.getUsersAndRefresh();
    }

    private void getUsersAndRefresh() {
        if (this.session.isUserDatabaseSynchronized()) {
            return;
        }
        final Composite label = new Composite(this.mainArea, 0);
        label.setLayout((Layout)new GridLayout());
        label.setBackground(label.getDisplay().getSystemColor(25));
        Label labelText = new Label(label, 0x1000000);
        labelText.setText("Loading...");
        labelText.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        labelText.setBackground(label.getBackground());
        label.moveAbove(null);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        fd.right = new FormAttachment(100, 0);
        label.setLayoutData((Object)fd);
        this.mainArea.layout();
        ConsoleJob job = new ConsoleJob("Synchronize users", null, "org.netxms.ui.eclipse.usermanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                UserManagementView.this.session.syncUserDatabase();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).UserManagementView.this.viewer.setInput((Object)(this).UserManagementView.this.session.getUserDatabaseObjects());
                        label.dispose();
                        (this).UserManagementView.this.mainArea.layout();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot synchronize users";
            }
        };
        job.setUser(false);
        job.start();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionAddUser);
        manager.add((IAction)this.actionAddGroup);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAddUser);
        manager.add((IAction)this.actionAddGroup);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void makeActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                UserManagementView.this.viewer.setInput((Object)UserManagementView.this.session.getUserDatabaseObjects());
            }
        };
        Messages.get();
        this.actionAddUser = new Action(Messages.UserManagementView_CreateNewUser, Activator.getImageDescriptor("icons/user_add.png")){

            public void run() {
                UserManagementView.this.addUser();
            }
        };
        Messages.get();
        this.actionAddGroup = new Action(Messages.UserManagementView_CreateNewGroup, Activator.getImageDescriptor("icons/group_add.png")){

            public void run() {
                UserManagementView.this.addGroup();
            }
        };
        this.actionEditUser = new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.viewer);
        Messages.get();
        this.actionEditUser.setText(Messages.UserManagementView_Properties);
        this.actionEditUser.setImageDescriptor(SharedIcons.EDIT);
        this.actionEditUser.setEnabled(false);
        Messages.get();
        this.actionDeleteUser = new Action(Messages.UserManagementView_Delete, SharedIcons.DELETE_OBJECT){

            public void run() {
                UserManagementView.this.deleteUser();
            }
        };
        this.actionDeleteUser.setEnabled(false);
        Messages.get();
        this.actionChangePassword = new Action(Messages.UserManagementView_ChangePassword, Activator.getImageDescriptor("icons/change_password.png")){

            public void run() {
                UserManagementView.this.changePassword();
            }
        };
        this.actionChangePassword.setEnabled(false);
        Messages.get();
        this.actionEnable = new Action(Messages.UserManagementView_Enable){

            public void run() {
                UserManagementView.this.enableUser();
            }
        };
        Messages.get();
        this.actionDisable = new Action(Messages.UserManagementView_Disable){

            public void run() {
                UserManagementView.this.disableUser();
            }
        };
        Messages.get();
        this.actionDetachUserFromLDAP = new Action(Messages.UserManagementView_DetachFromLDAP){

            public void run() {
                UserManagementView.this.detachLDAPUser();
            }
        };
        this.actionShowFilter = new Action("Show filter", 2){

            public void run() {
                UserManagementView.this.enableFilter(UserManagementView.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.getBooleanFromSettings("ActionManager.showFilter", true));
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.datacollection.commands.show_dci_filter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                UserManagementView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        UserAuthenticationMethod method;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        mgr.add((IAction)this.actionAddUser);
        mgr.add((IAction)this.actionAddGroup);
        mgr.add((IContributionItem)new Separator());
        boolean containDisabled = false;
        boolean containEnabled = false;
        boolean containLDAP = false;
        for (Object object : selection.toList()) {
            if (((AbstractUserObject)object).isDisabled()) {
                containDisabled = true;
            }
            if (!((AbstractUserObject)object).isDisabled()) {
                containEnabled = true;
            }
            if ((((AbstractUserObject)object).getFlags() & 0x80) == 0) continue;
            containLDAP = true;
        }
        if (containDisabled) {
            mgr.add((IAction)this.actionEnable);
        }
        if (containEnabled) {
            mgr.add((IAction)this.actionDisable);
        }
        if (containLDAP) {
            mgr.add((IAction)this.actionDetachUserFromLDAP);
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof User && ((method = ((User)selection.getFirstElement()).getAuthMethod()) == UserAuthenticationMethod.LOCAL || method == UserAuthenticationMethod.CERTIFICATE_OR_LOCAL)) {
            mgr.add((IAction)this.actionChangePassword);
        }
        mgr.add((IAction)this.actionDeleteUser);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionEditUser);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.sessionListener != null) {
            this.session.removeListener(this.sessionListener);
        }
        super.dispose();
    }

    private void addUser() {
        final CreateObjectDialog dlg = new CreateObjectDialog(this.getViewSite().getShell(), true);
        if (dlg.open() == 0) {
            Messages.get();
            new ConsoleJob(Messages.UserManagementView_CreateUserJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.usermanager", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    UserManagementView.this.editNewUser = dlg.isEditAfterCreate();
                    UserManagementView.this.session.createUser(dlg.getLoginName());
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.UserManagementView_CreateUserJobError;
                }
            }.start();
        }
    }

    private void addGroup() {
        final CreateObjectDialog dlg = new CreateObjectDialog(this.getViewSite().getShell(), false);
        if (dlg.open() == 0) {
            Messages.get();
            new ConsoleJob(Messages.UserManagementView_CreateGroupJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.usermanager", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    UserManagementView.this.editNewUser = dlg.isEditAfterCreate();
                    UserManagementView.this.session.createUserGroup(dlg.getLoginName());
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.UserManagementView_CreateGroupJobError;
                }
            }.start();
        }
    }

    private void deleteUser() {
        String string;
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1) {
            Messages.get();
            string = Messages.UserManagementView_ConfirmDeleteSingular;
        } else {
            Messages.get();
            string = Messages.UserManagementView_ConfirmDeletePlural;
        }
        String message = string;
        Shell shell = this.getViewSite().getShell();
        Messages.get();
        if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.UserManagementView_ConfirmDeleteTitle, (String)message)) {
            return;
        }
        Messages.get();
        new ConsoleJob(Messages.UserManagementView_DeleteJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.usermanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Object object : selection.toList()) {
                    UserManagementView.this.session.deleteUserDBObject(((AbstractUserObject)object).getId());
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.UserManagementView_DeleteJobError;
            }
        }.start();
    }

    private void enableUser() {
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Messages.get();
        new ConsoleJob(Messages.UserManagementView_DeleteJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.usermanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Object object : selection.toList()) {
                    ((AbstractUserObject)object).setFlags(((AbstractUserObject)object).getFlags() & 0xFFFFFFFB);
                    UserManagementView.this.session.modifyUserDBObject((AbstractUserObject)object, 8);
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.UserManagementView_EnableError;
            }
        }.start();
    }

    private void disableUser() {
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Messages.get();
        new ConsoleJob(Messages.UserManagementView_DeleteJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.usermanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Object object : selection.toList()) {
                    ((AbstractUserObject)object).setFlags(((AbstractUserObject)object).getFlags() | 4);
                    UserManagementView.this.session.modifyUserDBObject((AbstractUserObject)object, 8);
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.UserManagementView_DisableError;
            }
        }.start();
    }

    private void changePassword() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof User) {
            User user = (User)firstElement;
            ChangePasswordDialog dialog = new ChangePasswordDialog(this.getSite().getShell(), user.getId() == (long)this.session.getUserId());
            if (dialog.open() == 0) {
                try {
                    this.session.setUserPassword(user.getId(), dialog.getPassword(), dialog.getOldPassword());
                }
                catch (Exception e) {
                    Shell shell = this.getSite().getShell();
                    Messages.get();
                    MessageDialogHelper.openError((Shell)shell, (String)Messages.UserManagementView_CannotChangePassword, (String)e.getMessage());
                }
            }
        }
    }

    private void detachLDAPUser() {
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Messages.get();
        new ConsoleJob(Messages.UserManagementView_DeleteJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.usermanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Object object : selection.toList()) {
                    ((AbstractUserObject)object).setFlags(((AbstractUserObject)object).getFlags() & 0xFFFFFF7F);
                    UserManagementView.this.session.detachUserFromLdap(((AbstractUserObject)object).getId());
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.UserManagementView_DetachError;
            }
        }.start();
        this.changePassword();
    }

    private void enableFilter(boolean enable) {
        this.filterText.setVisible(enable);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.mainArea.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
        this.settings.put("DataCollectionEditor.showFilter", enable);
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    private boolean getBooleanFromSettings(String name, boolean defval) {
        String v = this.settings.get(name);
        return v != null ? Boolean.valueOf(v) : defval;
    }
}

