/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.dashboard.widgets.internal.StatusIndicatorConfig;
import org.netxms.ui.eclipse.datacollection.widgets.DciSelector;
import org.netxms.ui.eclipse.datacollection.widgets.TemplateDciSelector;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class StatusIndicatorElementEditDialog
extends Dialog {
    private StatusIndicatorConfig.StatusIndicatorElementConfig element;
    private LabeledText label;
    private ObjectSelector drilldownObjectSelector;
    private Combo typeSelector;
    private Composite typeSpecificControl;
    private ObjectSelector objectSelector;
    private DciSelector dciSelector;
    private TemplateDciSelector templateDciSelector;
    private LabeledText tagEditor;
    private String cachedDciName;

    public StatusIndicatorElementEditDialog(Shell parentShell, StatusIndicatorConfig.StatusIndicatorElementConfig element) {
        super(parentShell);
        this.element = element;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.element == null ? "Create Element" : "Edit Element");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        if (this.element == null) {
            this.element = new StatusIndicatorConfig.StatusIndicatorElementConfig();
        }
        this.label = new LabeledText(dialogArea, 0);
        this.label.setLabel("Label");
        this.label.setText(this.element.getLabel());
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 400;
        this.label.setLayoutData((Object)gd);
        this.typeSelector = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Type", (Object)"WidgetHelper::default_layout_data");
        this.typeSelector.add("Object");
        this.typeSelector.add("DCI");
        this.typeSelector.add("DCI Template");
        this.typeSelector.add("Script");
        this.typeSelector.select(this.element.getType());
        this.typeSelector.setLayoutData((Object)new GridData(4, 4, true, false));
        this.typeSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatusIndicatorElementEditDialog.this.createTypeSpecificControls();
            }
        });
        this.typeSpecificControl = new Composite(dialogArea, 0);
        this.typeSpecificControl.setLayout((Layout)new FillLayout());
        this.typeSpecificControl.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createTypeSpecificControls();
        this.drilldownObjectSelector = new ObjectSelector(dialogArea, 0, true);
        this.drilldownObjectSelector.setObjectClass(AbstractObject.class);
        this.drilldownObjectSelector.setClassFilter(ObjectSelectionDialog.createDashboardAndNetworkMapSelectionFilter());
        this.drilldownObjectSelector.setLabel("Drilldown object");
        this.drilldownObjectSelector.setLayoutData((Object)new GridData(4, 4, true, false));
        this.drilldownObjectSelector.setObjectId(this.element.getDrilldownObjectId());
        return dialogArea;
    }

    private void createTypeSpecificControls() {
        Control[] controlArray = this.typeSpecificControl.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        switch (this.typeSelector.getSelectionIndex()) {
            case 1: {
                this.dciSelector = new DciSelector(this.typeSpecificControl, 0, false);
                this.dciSelector.setLabel("Data collection item");
                this.dciSelector.setDciId(this.element.getObjectId(), this.element.getDciId());
                break;
            }
            case 2: {
                this.templateDciSelector = new TemplateDciSelector(this.typeSpecificControl, 0);
                this.templateDciSelector.setLabel("DCI name");
                this.templateDciSelector.setText(this.element.getDciName());
                break;
            }
            case 0: {
                this.objectSelector = new ObjectSelector(this.typeSpecificControl, 0, false);
                this.objectSelector.setLabel("Object");
                this.objectSelector.setObjectClass(AbstractObject.class);
                this.objectSelector.setObjectId(this.element.getObjectId());
                break;
            }
            case 3: {
                this.tagEditor = new LabeledText(this.typeSpecificControl, 0);
                this.tagEditor.setLabel("Tag");
                this.tagEditor.setText(this.element.getTag());
            }
        }
        if (this.getShell().isVisible()) {
            this.typeSpecificControl.getParent().layout(true, true);
            this.getShell().pack();
        }
    }

    protected void okPressed() {
        this.element.setLabel(this.label.getText().trim());
        this.element.setType(this.typeSelector.getSelectionIndex());
        this.element.setDrilldownObjectId(this.drilldownObjectSelector.getObjectId());
        switch (this.element.getType()) {
            case 1: {
                this.element.setObjectId(this.dciSelector.getNodeId());
                this.element.setDciId(this.dciSelector.getDciId());
                this.cachedDciName = this.dciSelector.getDciName();
                break;
            }
            case 2: {
                this.element.setDciName(this.templateDciSelector.getText());
                break;
            }
            case 0: {
                this.element.setObjectId(this.objectSelector.getObjectId());
                break;
            }
            case 3: {
                this.element.setTag(this.tagEditor.getText().trim());
            }
        }
        super.okPressed();
    }

    public StatusIndicatorConfig.StatusIndicatorElementConfig getElement() {
        return this.element;
    }

    public String getCachedDciName() {
        return this.cachedDciName;
    }
}

