/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.ui.IViewPart;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.TableValueConfig;
import org.netxms.ui.eclipse.perfview.widgets.TableValueViewer;
import org.netxms.ui.eclipse.tools.ViewRefreshController;

public class TableValueElement
extends ElementWidget {
    private TableValueConfig config;
    private TableValueViewer viewer;

    public TableValueElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = TableValueConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new TableValueConfig();
        }
        this.processCommonSettings(this.config);
        this.viewer = new TableValueViewer(this.getContentArea(), 0, viewPart, parent.getDashboardObject().getGuid().toString(), true);
        this.viewer.setObject(this.config.getObjectId(), this.config.getDciId());
        this.viewer.refresh(null);
        final ViewRefreshController refreshController = new ViewRefreshController(viewPart, this.config.getRefreshRate(), new Runnable(){

            @Override
            public void run() {
                if (TableValueElement.this.isDisposed()) {
                    return;
                }
                TableValueElement.this.viewer.refresh(null);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                refreshController.dispose();
            }
        });
    }
}

