/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets.internal;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.ObjectIdMatchingData;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementConfig;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.core.Persister;

public class FileMonitorConfig
extends DashboardElementConfig {
    @Element(required=true)
    private long objectId = 0L;
    @Element(required=false)
    private String fileName = "";
    @Element(required=false)
    private int historyLimit = 1000;
    @Element(required=false)
    private String filter = null;
    @Element(required=false)
    private String syntaxHighlighter = null;

    public static FileMonitorConfig createFromXml(String xml) throws Exception {
        Persister serializer = new Persister();
        return (FileMonitorConfig)serializer.read(FileMonitorConfig.class, xml);
    }

    @Override
    public String createXml() throws Exception {
        Persister serializer = new Persister();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, (Writer)writer);
        return ((Object)writer).toString();
    }

    @Override
    public Set<Long> getObjects() {
        Set<Long> objects = super.getObjects();
        objects.add(this.objectId);
        return objects;
    }

    @Override
    public void remapObjects(Map<Long, ObjectIdMatchingData> remapData) {
        super.remapObjects(remapData);
        ObjectIdMatchingData md = remapData.get(this.objectId);
        if (md != null) {
            this.objectId = md.dstId;
        }
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getHistoryLimit() {
        return this.historyLimit;
    }

    public void setHistoryLimit(int historyLimit) {
        this.historyLimit = historyLimit;
    }

    public String getFilter() {
        return this.filter != null ? this.filter : "";
    }

    public void setFilter(String filter) {
        this.filter = filter == null || filter.isBlank() ? null : filter;
    }

    public String getSyntaxHighlighter() {
        return this.syntaxHighlighter != null ? this.syntaxHighlighter : "";
    }

    public void setSyntaxHighlighter(String syntaxHighlighter) {
        this.syntaxHighlighter = syntaxHighlighter == null || syntaxHighlighter.isBlank() ? null : syntaxHighlighter;
    }
}

