/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.objects.AbstractNode;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.DeploymentStatus;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class DeploymentStatusLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static I18n i18n = LocalizationHelper.getI18n(DeploymentStatusLabelProvider.class);
    private static final String[] statusText = new String[]{i18n.tr("Pending"), i18n.tr("Uploading file"), i18n.tr("Installing"), i18n.tr("Completed"), i18n.tr("Failed"), i18n.tr("Initializing")};
    private BaseObjectLabelProvider objectLabelProvider = new BaseObjectLabelProvider();
    private Image imageActive = ResourceManager.getImage((String)"icons/deployStatus/active.png");
    private Image imagePending = ResourceManager.getImage((String)"icons/deployStatus/pending.png");
    private Image imageCompleted = ResourceManager.getImage((String)"icons/deployStatus/complete.png");
    private Image imageFailed = ResourceManager.getImage((String)"icons/deployStatus/failed.png");

    public Image getColumnImage(Object element, int columnIndex) {
        DeploymentStatus s = (DeploymentStatus)element;
        switch (columnIndex) {
            case 0: {
                AbstractNode node = s.getNodeObject();
                return this.objectLabelProvider.getImage((Object)node);
            }
            case 1: {
                switch (s.getStatus()) {
                    case 3: {
                        return this.imageCompleted;
                    }
                    case 4: {
                        return this.imageFailed;
                    }
                    case 1: 
                    case 2: 
                    case 5: {
                        return this.imageActive;
                    }
                    case 0: {
                        return this.imagePending;
                    }
                }
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DeploymentStatus s = (DeploymentStatus)element;
        switch (columnIndex) {
            case 0: {
                return s.getNodeName();
            }
            case 1: {
                try {
                    return statusText[s.getStatus()];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return i18n.tr("Unknown");
                }
            }
            case 2: {
                return s.getMessage();
            }
        }
        return null;
    }

    public void dispose() {
        this.objectLabelProvider.dispose();
        this.imageActive.dispose();
        this.imageCompleted.dispose();
        this.imageFailed.dispose();
        this.imagePending.dispose();
        super.dispose();
    }
}

