/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.events.Alarm;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class AlarmNotifier {
    private static final Logger logger = LoggerFactory.getLogger(AlarmNotifier.class);
    private static final String[] SEVERITY_TEXT = new String[]{"NORMAL", "WARNING", "MINOR", "MAJOR", "CRITICAL", "REMINDER"};
    private I18n i18n = LocalizationHelper.getI18n(AlarmNotifier.class);
    private SessionListener listener = null;
    private Map<Long, Integer> alarmStates = new HashMap();
    private int outstandingAlarms = 0;
    private long lastReminderTime = 0L;
    private NXCSession session;
    private PreferenceStore ps;
    private LinkedBlockingQueue<String> soundQueue = new LinkedBlockingQueue(4);
    private File soundFilesDirectory;

    private static AlarmNotifier getInstance() {
        return (AlarmNotifier)RWT.getUISession().getAttribute("netxms.alarmNotifier");
    }

    private static AlarmNotifier getInstance(Display display) {
        return (AlarmNotifier)RWT.getUISession((Display)display).getAttribute("netxms.alarmNotifier");
    }

    public static void init(NXCSession session, Display display) {
        RWT.getUISession((Display)display).setAttribute("netxms.alarmNotifier", (Object)new AlarmNotifier(session));
    }

    private AlarmNotifier(NXCSession session) {
        this.session = session;
        this.ps = PreferenceStore.getInstance();
        this.soundFilesDirectory = new File(Registry.getStateDir(), "sounds");
        if (!this.soundFilesDirectory.isDirectory()) {
            this.soundFilesDirectory.mkdirs();
        }
        this.checkSounds();
        this.lastReminderTime = System.currentTimeMillis();
        try {
            HashMap alarms = session.getAlarms();
            for (Alarm a : alarms.values()) {
                this.alarmStates.put(a.getId(), a.getState());
                if (a.getState() != 0) continue;
                ++this.outstandingAlarms;
            }
            logger.info(String.format("Received %d alarms from server (%d outstanding)", alarms.size(), this.outstandingAlarms));
        }
        catch (Exception e) {
            logger.error("Exception while initializing alarm notifier", (Throwable)e);
        }
        this.listener = new /* Unavailable Anonymous Inner Class!! */;
        session.addListener(this.listener);
        Thread reminderThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */, "AlarmReminderThread");
        reminderThread.setDaemon(true);
        reminderThread.start();
        Thread playerThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */, "AlarmSoundPlayer");
        playerThread.setDaemon(true);
        playerThread.start();
    }

    private void checkSounds() {
        for (String s : SEVERITY_TEXT) {
            this.getSoundAndDownloadIfRequired(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSoundAndDownloadIfRequired(String severity) {
        String soundName;
        block12: {
            soundName = this.ps.getAsString("AlarmNotifier.Sound." + severity);
            if (soundName == null || soundName.isEmpty()) {
                return null;
            }
            if (!this.isSoundFileExist(soundName)) {
                try {
                    File fileContent = this.session.downloadFileFromServer(soundName);
                    if (fileContent != null) {
                        FileInputStream src = null;
                        FileOutputStream dest = null;
                        try {
                            src = new FileInputStream(fileContent);
                            File f = new File(this.soundFilesDirectory, soundName);
                            f.createNewFile();
                            dest = new FileOutputStream(f);
                            FileChannel fcSrc = src.getChannel();
                            dest.getChannel().transferFrom(fcSrc, 0L, fcSrc.size());
                            break block12;
                        }
                        catch (IOException e) {
                            logger.error("Cannot copy sound file", (Throwable)e);
                            break block12;
                        }
                        finally {
                            if (src != null) {
                                src.close();
                            }
                            if (dest != null) {
                                dest.close();
                            }
                        }
                    }
                    logger.error("Cannot download sound file " + soundName + " from server");
                    soundName = null;
                }
                catch (Exception e) {
                    soundName = null;
                    this.ps.set("AlarmNotifier.Sound." + severity, "");
                    Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                }
            }
        }
        return soundName;
    }

    private boolean isSoundFileExist(String name) {
        if (name.isEmpty()) {
            return true;
        }
        File f = new File(this.soundFilesDirectory, name);
        return f.isFile();
    }

    public static void stop() {
        NXCSession session = Registry.getSession();
        AlarmNotifier instance = AlarmNotifier.getInstance();
        if (session != null && instance != null && instance.listener != null) {
            session.removeListener(instance.listener);
        }
    }

    public static boolean isGlobalSoundEnabled(Display display) {
        return !AlarmNotifier.getInstance((Display)display).ps.getAsBoolean("AlarmNotifier.LocalSound", false);
    }

    public static void playSounOnAlarm(Alarm alarm) {
        AlarmNotifier.getInstance().soundQueue.offer(SEVERITY_TEXT[alarm.getCurrentSeverity().getValue()]);
    }

    private void processNewAlarm(Alarm alarm) {
        Integer state = (Integer)this.alarmStates.get(alarm.getId());
        if (state != null && state == 0) {
            --this.outstandingAlarms;
        }
        this.alarmStates.put(alarm.getId(), alarm.getState());
        if (alarm.getState() != 0) {
            return;
        }
        if (!this.ps.getAsBoolean("AlarmNotifier.LocalSound", false)) {
            this.soundQueue.offer(SEVERITY_TEXT[alarm.getCurrentSeverity().getValue()]);
        }
        if (this.outstandingAlarms == 0) {
            this.lastReminderTime = System.currentTimeMillis();
        }
        ++this.outstandingAlarms;
    }
}

