/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import org.netxms.client.AgentFileData;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.FileMonitorConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.modules.filemanager.widgets.DynamicFileViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class FileMonitorElement
extends ElementWidget {
    private static final Logger logger = LoggerFactory.getLogger(FileMonitorElement.class);
    private final I18n i18n = LocalizationHelper.getI18n(FileMonitorElement.class);
    private FileMonitorConfig config;
    private DynamicFileViewer viewer;
    private NXCSession session;
    private AgentFileData file;

    protected FileMonitorElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.config = FileMonitorConfig.createFromXml((String)element.getData());
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.config = new FileMonitorConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.config);
        this.session = Registry.getSession();
        this.viewer = new DynamicFileViewer(this.getContentArea(), 0, (View)view);
        this.viewer.setLineCountLimit(this.config.getHistoryLimit());
        this.viewer.setAppendFilter(this.config.getFilter());
        long nodeId = this.getEffectiveObjectId(this.config.getObjectId());
        new /* Unavailable Anonymous Inner Class!! */.start();
    }
}

