/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class SaveGraphDlg
extends Dialog {
    private static final I18n i18n = LocalizationHelper.getI18n(SaveGraphDlg.class);
    public static final int OVERRIDE = 101;
    private LabeledText fieldName;
    private Label errorMessage;
    private String name;
    private Button checkOverwrite;
    private String errorMessageText;
    private boolean havePermissionToOverwrite;

    public SaveGraphDlg(Shell parentShell, String initialName, String message, boolean havePermissionToOverwrite) {
        super(parentShell);
        this.name = initialName;
        this.errorMessageText = message;
        this.havePermissionToOverwrite = havePermissionToOverwrite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(i18n.tr("Save Graph"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.fieldName = new LabeledText(dialogArea, 0);
        this.fieldName.setLabel(i18n.tr("Name"));
        this.fieldName.setText(this.name);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        this.fieldName.setLayoutData((Object)gd);
        if (this.errorMessageText != null) {
            this.errorMessage = new Label(dialogArea, 16384);
            this.errorMessage.setForeground(ThemeEngine.getForegroundColor((String)"List.Error"));
            this.errorMessage.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.errorMessage.setText(this.errorMessageText);
        }
        if (this.havePermissionToOverwrite) {
            this.checkOverwrite = new Button(dialogArea, 32);
            this.checkOverwrite.setText(i18n.tr("Overwrite existing graph"));
        }
        return dialogArea;
    }

    protected void okPressed() {
        this.name = this.fieldName.getText().trim();
        if (this.name.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)i18n.tr("Warning"), (String)i18n.tr("Predefined graph name must not be empty!"));
            return;
        }
        if (this.havePermissionToOverwrite && this.checkOverwrite.getSelection()) {
            this.setReturnCode(101);
            super.close();
        } else {
            super.okPressed();
        }
    }

    public String getName() {
        return this.name;
    }
}

