/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages.helpers;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCSession;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.client.users.UserGroup;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.resources.SharedIcons;

public class AccessListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color HINT_FOREGROUND = new Color((Device)Display.getDefault(), 192, 192, 192);
    private NXCSession session = Registry.getSession();

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof AccessListElement) {
                return (((AccessListElement)element).getUserId() & 0x40000000L) == 0L ? SharedIcons.IMG_USER : SharedIcons.IMG_GROUP;
            }
            if (element instanceof User) {
                return SharedIcons.IMG_USER;
            }
            if (element instanceof UserGroup) {
                return SharedIcons.IMG_GROUP;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (element instanceof AccessListElement) {
                    return this.getUserName((AccessListElement)element);
                }
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof User) {
                    return this.getUserName((User)element);
                }
                if (element instanceof UserGroup) {
                    return this.getUserName((UserGroup)element);
                }
            }
            case 1: {
                AccessListElement e = (AccessListElement)element;
                StringBuilder sb = new StringBuilder(4);
                sb.append((e.getAccessRights() & 1) != 0 ? (char)'R' : '-');
                sb.append((e.getAccessRights() & 2) != 0 ? (char)'W' : '-');
                return sb.toString();
            }
        }
        return null;
    }

    private String getUserName(AccessListElement element) {
        long userId = element.getUserId();
        AbstractUserObject dbo = this.session.findUserDBObjectById(userId, null);
        return dbo != null ? dbo.getName() : "{" + Long.toString(userId) + "}";
    }

    private String getUserName(User element) {
        StringBuilder sb = new StringBuilder();
        if (element.getFullName().isEmpty()) {
            sb.append(element.getName());
        } else {
            sb.append(String.format("%s <%s>", element.getName(), element.getFullName()));
        }
        if (!element.getDescription().isEmpty()) {
            sb.append(String.format(" (%s)", element.getDescription()));
        }
        return sb.toString();
    }

    private String getUserName(UserGroup element) {
        StringBuilder sb = new StringBuilder();
        sb.append(element.getName());
        if (!element.getDescription().isEmpty()) {
            sb.append(String.format(" (%s)", element.getDescription()));
        }
        return sb.toString();
    }

    public Color getForeground(Object element) {
        if (element instanceof String) {
            return HINT_FOREGROUND;
        }
        return null;
    }

    public Color getBackground(Object arg0) {
        return null;
    }
}

