/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.filemanager.widgets;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.StyledText;
import org.netxms.nxmc.base.widgets.helpers.LineStyleListener;
import org.netxms.nxmc.base.widgets.helpers.StyleRange;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.filemanager.widgets.BaseFileViewer;
import org.netxms.nxmc.resources.SharedIcons;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class BaseFileViewer
extends Composite {
    private static final Logger logger = LoggerFactory.getLogger(BaseFileViewer.class);
    private static final I18n i18n = LocalizationHelper.getI18n(BaseFileViewer.class);
    public static final int INFORMATION = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final long MAX_FILE_SIZE = 0x4000000L;
    protected View view;
    protected StyledText text;
    protected Composite searchBar;
    protected Text searchBarText;
    protected Label searchCloseButton;
    protected boolean scrollLock = false;
    private int lineCountLimit = 0;
    protected StringBuilder content = new StringBuilder();
    protected LineStyler lineStyler = null;
    protected Pattern appendFilter = null;
    protected String lineRemainder = null;

    public BaseFileViewer(Composite parent, int style, View view) {
        super(parent, style);
        this.view = view;
        this.setLayout((Layout)new FormLayout());
        this.text = new StyledText((Composite)this, 768);
        this.text.setFont(JFaceResources.getTextFont());
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.text.setLayoutData((Object)fd);
        this.text.addLineStyleListener((LineStyleListener)new /* Unavailable Anonymous Inner Class!! */);
        this.searchBar = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 3;
        layout.marginBottom = 3;
        layout.numColumns = 3;
        this.searchBar.setLayout((Layout)layout);
        this.searchBar.setVisible(false);
        Label separator = new Label(this.searchBar, 258);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 3;
        separator.setLayoutData((Object)gd);
        Label searchBarLabel = new Label(this.searchBar, 16384);
        searchBarLabel.setText(i18n.tr("Find:"));
        searchBarLabel.setBackground(this.searchBar.getBackground());
        searchBarLabel.setForeground(this.searchBar.getForeground());
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.verticalAlignment = 0x1000000;
        gd.horizontalIndent = 5;
        searchBarLabel.setLayoutData((Object)gd);
        Composite searchBarTextContainer = new Composite(this.searchBar, 2048);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        layout.horizontalSpacing = 0;
        searchBarTextContainer.setLayout((Layout)layout);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 16384;
        gd.widthHint = 400;
        searchBarTextContainer.setLayoutData((Object)gd);
        this.searchBarText = new Text(searchBarTextContainer, 0);
        this.searchBarText.setMessage(i18n.tr("Find in file"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 0x1000000;
        gd.grabExcessHorizontalSpace = true;
        this.searchBarText.setLayoutData((Object)gd);
        this.searchBarText.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.searchBarText.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        searchBarTextContainer.setBackground(this.searchBarText.getBackground());
        ToolBar searchButtons = new ToolBar(searchBarTextContainer, 0x800000);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 16384;
        searchButtons.setLayoutData((Object)gd);
        ToolItem item = new ToolItem(searchButtons, 8);
        item.setImage(SharedIcons.IMG_UP);
        item.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        item = new ToolItem(searchButtons, 8);
        item.setImage(SharedIcons.IMG_DOWN);
        item.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.searchCloseButton = new Label(this.searchBar, 0);
        this.searchCloseButton.setBackground(this.searchBar.getBackground());
        this.searchCloseButton.setCursor(this.getDisplay().getSystemCursor(21));
        this.searchCloseButton.setImage(SharedIcons.IMG_CLOSE);
        this.searchCloseButton.setToolTipText(i18n.tr("Close"));
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 131072;
        gd.widthHint = 20;
        this.searchCloseButton.setLayoutData((Object)gd);
        this.searchCloseButton.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.searchBar.setLayoutData((Object)fd);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void showFile(File file, boolean scrollToEnd) {
        8 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public void showSearchBar() {
        this.searchBarText.setText("");
        this.searchBar.setVisible(true);
        ((FormData)this.text.getLayoutData()).bottom = new FormAttachment((Control)this.searchBar, 0, 128);
        this.layout(true, true);
        this.searchBarText.setFocus();
    }

    public void hideSearchBar() {
        this.searchBar.setVisible(false);
        ((FormData)this.text.getLayoutData()).bottom = new FormAttachment(100, 0);
        this.layout(true, true);
    }

    public void clear() {
        this.content = new StringBuilder();
        this.text.setText("");
    }

    public void selectAll() {
    }

    public void copy() {
    }

    public boolean canCopy() {
        return false;
    }

    public boolean isScrollLock() {
        return this.scrollLock;
    }

    public void setScrollLock(boolean scrollLock) {
        this.scrollLock = scrollLock;
        this.text.setScrollOnAppend(!scrollLock);
    }

    public int getLineCountLimit() {
        return this.lineCountLimit;
    }

    public void setLineCountLimit(int lineCountLimit) {
        this.lineCountLimit = lineCountLimit;
    }

    public void setAppendFilter(String regex) {
        if (regex != null && !regex.isEmpty()) {
            try {
                this.appendFilter = Pattern.compile(regex, 2);
            }
            catch (PatternSyntaxException e) {
                logger.warn("Syntax error in file viewer append filter (regex=\"" + regex + "\")", (Throwable)e);
                this.appendFilter = null;
            }
        } else {
            this.appendFilter = null;
        }
    }

    public Control getTextControl() {
        return this.text;
    }

    public void addSelectionListener(SelectionListener listener) {
    }

    public void removeSelectionListener(SelectionListener listener) {
    }

    public void replaceContent(BaseFileViewer source) {
        this.text.replaceContent(source.text);
    }

    protected void setContent(String s) {
        this.lineRemainder = null;
        String ps = this.filterText(BaseFileViewer.removeEscapeSequences((String)s));
        this.text.setText(ps);
        this.content = new StringBuilder();
        this.content.append(ps.toLowerCase());
        if (this.lineCountLimit > 0) {
            int lineCount = this.text.getLineCount();
            if (this.lineCountLimit > 0 && lineCount > this.lineCountLimit) {
                int length = this.text.getOffsetAtLine(lineCount - this.lineCountLimit);
                this.text.replaceTextRange(0, length, "");
                this.content.replace(0, length, "");
            }
        }
    }

    protected void append(String s) {
        String ps = this.filterText(BaseFileViewer.removeEscapeSequences((String)s));
        this.content.append(ps.toLowerCase());
        this.text.append(ps);
        if (this.lineCountLimit > 0) {
            int lineCount = this.text.getLineCount();
            if (this.lineCountLimit > 0 && lineCount > this.lineCountLimit) {
                int length = this.text.getOffsetAtLine(lineCount - this.lineCountLimit);
                this.text.replaceTextRange(0, length, "");
                this.content.replace(0, length, "");
            }
        }
    }

    private String filterText(String text) {
        if (this.appendFilter == null) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        if (this.lineRemainder != null) {
            sb.append(this.lineRemainder);
            this.lineRemainder = null;
        }
        sb.append(text);
        StringBuilder output = new StringBuilder();
        int offset = 0;
        while (offset < sb.length()) {
            int nextOffset = sb.indexOf("\n", offset);
            if (nextOffset == -1) {
                this.lineRemainder = sb.substring(offset);
                break;
            }
            String line = sb.substring(offset, nextOffset + 1);
            if (this.appendFilter.matcher(line).find()) {
                output.append(line);
            }
            offset = nextOffset + 1;
        }
        return output.toString();
    }

    protected StyleRange[] styleLine(String line) {
        return this.lineStyler != null ? this.lineStyler.styleLine(line) : null;
    }

    public LineStyler getLineStyler() {
        return this.lineStyler;
    }

    public void setLineStyler(LineStyler lineStyler) {
        if (this.lineStyler == lineStyler) {
            return;
        }
        if (this.lineStyler != null) {
            this.lineStyler.dispose();
        }
        this.lineStyler = lineStyler;
    }

    private void doSearch(boolean typing) {
    }

    private void doReverseSearch() {
    }

    protected static String removeEscapeSequences(String s) {
        s = s.replaceAll("\r(?!\n)", "\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\u001b') {
                if ((ch = s.charAt(++i)) == '[') {
                    while (!(i >= s.length() || (ch = s.charAt(i)) >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
                        ++i;
                    }
                    continue;
                }
                if (ch != '(' && ch != ')') continue;
                ++i;
                continue;
            }
            if (ch < ' ' && ch != '\r' && ch != '\n' && ch != '\t') continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String loadFile(File file) {
        StringBuilder content = new StringBuilder();
        FileReader reader = null;
        char[] buffer = new char[32768];
        try {
            reader = new FileReader(file);
            int size = 0;
            while ((long)size < 0x4000000L) {
                int count = reader.read(buffer);
                if (count == -1) {
                    break;
                }
                if (count == buffer.length) {
                    content.append(buffer);
                } else {
                    content.append(Arrays.copyOf(buffer, count));
                }
                size += count;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return content.toString();
    }

    protected void setTextTopIndex() {
    }

    protected void setScrollOnAppend(boolean scrollLock) {
        this.text.setScrollOnAppend(!scrollLock);
    }
}

