/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Zone;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.modules.objects.widgets.ZoneSelector;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class CreateNodeDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(CreateNodeDialog.class);
    private NXCSession session = Registry.getSession();
    private LabeledText objectNameField;
    private LabeledText objectAliasField;
    private LabeledText hostNameField;
    private Spinner agentPortField;
    private Spinner snmpPortField;
    private Spinner etherNetIpPortField;
    private Spinner sshPortField;
    private LabeledText sshLoginField;
    private LabeledText sshPasswordField;
    private Button checkUnmanaged;
    private Button checkMaintenanceMode;
    private Button checkAsZoneProxy;
    private Button checkDisableAgent;
    private Button checkDisableSNMP;
    private Button checkDisableSSH;
    private Button checkDisableEtherNetIP;
    private Button checkDisablePing;
    private Button checkCreateAnother;
    private Button checkDisableAutomaticSNMPConfig;
    private Button checkRemoteManagementNode;
    private ObjectSelector agentProxySelector;
    private ObjectSelector snmpProxySelector;
    private ObjectSelector etherNetIpProxySelector;
    private ObjectSelector icmpProxySelector;
    private ObjectSelector sshProxySelector;
    private ObjectSelector webServiceProxySelector;
    private ZoneSelector zoneSelector;
    private String objectName = "";
    private String objectAlias = "";
    private String hostName = "";
    private int creationFlags = 0;
    private long agentProxy = 0L;
    private long snmpProxy = 0L;
    private long etherNetIpProxy = 0L;
    private long icmpProxy = 0L;
    private long sshProxy = 0L;
    private long webServiceProxy = 0L;
    private int zoneUIN = 0;
    private int agentPort = 4700;
    private int snmpPort = 161;
    private int etherNetIpPort = 44818;
    private int sshPort = 22;
    private String sshLogin = "";
    private String sshPassword;
    private boolean showAgain = false;
    private boolean enableShowAgainFlag = true;

    public CreateNodeDialog(Shell parentShell, CreateNodeDialog prev) {
        super(parentShell);
        if (prev != null) {
            this.creationFlags = prev.creationFlags;
            this.agentProxy = prev.agentProxy;
            this.snmpProxy = prev.snmpProxy;
            this.icmpProxy = prev.snmpProxy;
            this.sshProxy = prev.snmpProxy;
            this.webServiceProxy = prev.webServiceProxy;
            this.zoneUIN = prev.zoneUIN;
            this.agentPort = prev.agentPort;
            this.snmpPort = prev.snmpPort;
            this.sshLogin = prev.sshLogin;
            this.sshPassword = prev.sshPassword;
            this.sshPort = prev.sshPort;
            this.showAgain = prev.showAgain;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Create Node Object"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.objectNameField = new LabeledText(dialogArea, 0);
        this.objectNameField.setLabel(this.i18n.tr("Name"));
        this.objectNameField.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 600;
        gd.horizontalSpan = 2;
        this.objectNameField.setLayoutData((Object)gd);
        this.objectNameField.setText(this.objectName);
        this.objectAliasField = new LabeledText(dialogArea, 0);
        this.objectAliasField.setLabel(this.i18n.tr("Alias"));
        this.objectAliasField.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectAliasField.setLayoutData((Object)gd);
        this.objectAliasField.setText(this.objectAlias);
        Composite ipAddrGroup = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        ipAddrGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        ipAddrGroup.setLayoutData((Object)gd);
        this.hostNameField = new LabeledText(ipAddrGroup, 0);
        this.hostNameField.setLabel(this.i18n.tr("Primary host name or IP address"));
        this.hostNameField.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.hostNameField.setLayoutData((Object)gd);
        this.hostNameField.setText(this.hostName);
        this.agentPortField = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)this.i18n.tr("NetXMS agent port"), (int)1, (int)65535, (Object)"WidgetHelper::default_layout_data");
        this.agentPortField.setSelection(this.agentPort);
        this.snmpPortField = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)this.i18n.tr("SNMP agent port"), (int)1, (int)65535, (Object)"WidgetHelper::default_layout_data");
        this.snmpPortField.setSelection(this.snmpPort);
        this.etherNetIpPortField = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)this.i18n.tr("EtherNet/IP port"), (int)1, (int)65535, (Object)"WidgetHelper::default_layout_data");
        this.etherNetIpPortField.setSelection(this.etherNetIpPort);
        this.sshPortField = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)this.i18n.tr("SSH port"), (int)1, (int)65535, (Object)"WidgetHelper::default_layout_data");
        this.sshPortField.setSelection(this.sshPort);
        this.sshLoginField = new LabeledText(dialogArea, 0);
        this.sshLoginField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sshLoginField.setLabel(this.i18n.tr("SSH login"));
        this.sshLoginField.setText(this.sshLogin);
        this.sshPasswordField = new LabeledText(dialogArea, 0);
        this.sshPasswordField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sshPasswordField.setLabel(this.i18n.tr("SSH password"));
        this.sshPasswordField.setText(this.sshPassword);
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText(this.i18n.tr("Options"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        optionsGroup.setLayoutData((Object)gd);
        optionsGroup.setLayout((Layout)new RowLayout(512));
        this.checkRemoteManagementNode = new Button((Composite)optionsGroup, 32);
        this.checkRemoteManagementNode.setText(this.i18n.tr("Communication through external &gateway"));
        this.checkRemoteManagementNode.setSelection((this.creationFlags & NXCObjectCreationData.CF_EXTERNAL_GATEWAY) != 0);
        this.checkUnmanaged = new Button((Composite)optionsGroup, 32);
        this.checkUnmanaged.setText(this.i18n.tr("Create as &unmanaged object"));
        this.checkUnmanaged.setSelection((this.creationFlags & NXCObjectCreationData.CF_CREATE_UNMANAGED) != 0);
        this.checkMaintenanceMode = new Button((Composite)optionsGroup, 32);
        this.checkMaintenanceMode.setText(this.i18n.tr("Enter &maintenance mode immediately"));
        this.checkMaintenanceMode.setSelection((this.creationFlags & NXCObjectCreationData.CF_ENTER_MAINTENANCE) != 0);
        if (this.session.isZoningEnabled()) {
            this.checkAsZoneProxy = new Button((Composite)optionsGroup, 32);
            this.checkAsZoneProxy.setText(this.i18n.tr("Create as zone proxy for selected zone"));
            this.checkAsZoneProxy.setSelection((this.creationFlags & NXCObjectCreationData.CF_AS_ZONE_PROXY) != 0);
            this.checkAsZoneProxy.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.checkDisableAgent = new Button((Composite)optionsGroup, 32);
        this.checkDisableAgent.setText(this.i18n.tr("Disable usage of NetXMS &agent for all polls"));
        this.checkDisableAgent.setSelection((this.creationFlags & NXCObjectCreationData.CF_DISABLE_NXCP) != 0);
        this.checkDisableSNMP = new Button((Composite)optionsGroup, 32);
        this.checkDisableSNMP.setText(this.i18n.tr("Disable usage of &SNMP for all polls"));
        this.checkDisableSNMP.setSelection((this.creationFlags & NXCObjectCreationData.CF_DISABLE_SNMP) != 0);
        this.checkDisableSSH = new Button((Composite)optionsGroup, 32);
        this.checkDisableSSH.setText("Disable usage of SSH for all polls");
        this.checkDisableSSH.setSelection((this.creationFlags & NXCObjectCreationData.CF_DISABLE_SSH) != 0);
        this.checkDisablePing = new Button((Composite)optionsGroup, 32);
        this.checkDisablePing.setText(this.i18n.tr("Disable usage of &ICMP ping for all polls"));
        this.checkDisablePing.setSelection((this.creationFlags & NXCObjectCreationData.CF_DISABLE_ICMP) != 0);
        this.checkDisableEtherNetIP = new Button((Composite)optionsGroup, 32);
        this.checkDisableEtherNetIP.setText("Disable usage of &EtherNet/IP for all polls");
        this.checkDisableEtherNetIP.setSelection((this.creationFlags & NXCObjectCreationData.CF_DISABLE_ETHERNET_IP) != 0);
        this.checkDisableAutomaticSNMPConfig = new Button((Composite)optionsGroup, 32);
        this.checkDisableAutomaticSNMPConfig.setText(this.i18n.tr("&Prevent automatic SNMP configuration changes"));
        this.checkDisableAutomaticSNMPConfig.setSelection((this.creationFlags & NXCObjectCreationData.CF_SNMP_SETTINGS_LOCKED) != 0);
        this.agentProxySelector = new ObjectSelector(dialogArea, 0, true);
        this.agentProxySelector.setLabel(this.i18n.tr("Proxy for NetXMS agents"));
        this.agentProxySelector.setObjectClass(Node.class);
        this.agentProxySelector.setObjectId(this.agentProxy);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.agentProxySelector.setLayoutData((Object)gd);
        this.snmpProxySelector = new ObjectSelector(dialogArea, 0, true);
        this.snmpProxySelector.setLabel(this.i18n.tr("Proxy for SNMP"));
        this.snmpProxySelector.setObjectClass(Node.class);
        this.snmpProxySelector.setObjectId(this.snmpProxy);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.snmpProxySelector.setLayoutData((Object)gd);
        this.etherNetIpProxySelector = new ObjectSelector(dialogArea, 0, true);
        this.etherNetIpProxySelector.setLabel(this.i18n.tr("Proxy for EtherNet/IP"));
        this.etherNetIpProxySelector.setObjectClass(Node.class);
        this.etherNetIpProxySelector.setObjectId(this.etherNetIpProxy);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.etherNetIpProxySelector.setLayoutData((Object)gd);
        this.icmpProxySelector = new ObjectSelector(dialogArea, 0, true);
        this.icmpProxySelector.setLabel(this.i18n.tr("Proxy for ICMP"));
        this.icmpProxySelector.setObjectClass(Node.class);
        this.icmpProxySelector.setObjectId(this.icmpProxy);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.icmpProxySelector.setLayoutData((Object)gd);
        this.sshProxySelector = new ObjectSelector(dialogArea, 0, true);
        this.sshProxySelector.setLabel(this.i18n.tr("Proxy for SSH"));
        this.sshProxySelector.setEmptySelectionName("<default>");
        this.sshProxySelector.setObjectClass(Node.class);
        this.sshProxySelector.setObjectId(this.sshProxy);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.sshProxySelector.setLayoutData((Object)gd);
        this.webServiceProxySelector = new ObjectSelector(dialogArea, 0, true);
        this.webServiceProxySelector.setLabel(this.i18n.tr("Proxy for web services"));
        this.webServiceProxySelector.setEmptySelectionName("<default>");
        this.webServiceProxySelector.setObjectClass(Node.class);
        this.webServiceProxySelector.setObjectId(this.webServiceProxy);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.webServiceProxySelector.setLayoutData((Object)gd);
        if (this.session.isZoningEnabled()) {
            this.zoneSelector = new ZoneSelector(dialogArea, 0, false);
            this.zoneSelector.setLabel(this.i18n.tr("Zone"));
            Zone zone = this.session.findZone(this.zoneUIN);
            this.zoneSelector.setZoneUIN(zone != null ? zone.getUIN() : -1);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.zoneSelector.setLayoutData((Object)gd);
        }
        if (this.enableShowAgainFlag) {
            this.checkCreateAnother = new Button(dialogArea, 32);
            this.checkCreateAnother.setText(this.i18n.tr("Show this dialog again to &create another node"));
            this.checkCreateAnother.setSelection(this.showAgain);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.checkCreateAnother.setLayoutData((Object)gd);
        }
        return dialogArea;
    }

    protected void okPressed() {
        this.hostName = this.hostNameField.getText().trim();
        if (this.hostName.isEmpty()) {
            this.hostName = this.objectNameField.getText().trim();
        }
        if (!this.hostName.matches("^(([A-Za-z0-9_-]+\\.)*[A-Za-z0-9_-]+|[A-Fa-f0-9:]+)$")) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)String.format(this.i18n.tr("String \"%s\" is not a valid host name or IP address. Please enter valid host name or IP address as primary host name"), this.hostName));
            return;
        }
        this.objectName = this.objectNameField.getText().trim();
        if (this.objectName.isEmpty()) {
            this.objectName = this.hostName;
        }
        this.creationFlags = 0;
        if (this.checkUnmanaged.getSelection()) {
            this.creationFlags |= NXCObjectCreationData.CF_CREATE_UNMANAGED;
        }
        if (this.checkMaintenanceMode.getSelection()) {
            this.creationFlags |= NXCObjectCreationData.CF_ENTER_MAINTENANCE;
        }
        if (this.session.isZoningEnabled() && this.checkAsZoneProxy.getSelection()) {
            this.creationFlags |= NXCObjectCreationData.CF_AS_ZONE_PROXY;
        }
        if (this.checkDisableAgent.getSelection()) {
            this.creationFlags |= NXCObjectCreationData.CF_DISABLE_NXCP;
        }
        if (this.checkDisablePing.getSelection()) {
            this.creationFlags |= NXCObjectCreationData.CF_DISABLE_ICMP;
        }
        if (this.checkDisableSNMP.getSelection()) {
            this.creationFlags |= NXCObjectCreationData.CF_DISABLE_SNMP;
        }
        if (this.checkDisableSSH.getSelection()) {
            this.creationFlags |= NXCObjectCreationData.CF_DISABLE_SSH;
        }
        if (this.checkDisableEtherNetIP.getSelection()) {
            this.creationFlags |= NXCObjectCreationData.CF_DISABLE_ETHERNET_IP;
        }
        if (this.checkDisableAutomaticSNMPConfig.getSelection()) {
            this.creationFlags |= NXCObjectCreationData.CF_SNMP_SETTINGS_LOCKED;
        }
        if (this.checkRemoteManagementNode.getSelection()) {
            this.creationFlags |= NXCObjectCreationData.CF_EXTERNAL_GATEWAY;
        }
        this.objectAlias = this.objectAliasField.getText().trim();
        this.agentPort = this.agentPortField.getSelection();
        this.snmpPort = this.snmpPortField.getSelection();
        this.etherNetIpPort = this.etherNetIpPortField.getSelection();
        this.sshPort = this.sshPortField.getSelection();
        this.sshLogin = this.sshLoginField.getText().trim();
        this.sshPassword = this.sshPasswordField.getText();
        this.agentProxy = this.agentProxySelector.getObjectId();
        this.snmpProxy = this.snmpProxySelector.getObjectId();
        this.etherNetIpProxy = this.etherNetIpProxySelector.getObjectId();
        this.icmpProxy = this.icmpProxySelector.getObjectId();
        this.sshProxy = this.sshProxySelector.getObjectId();
        this.webServiceProxy = this.webServiceProxySelector.getObjectId();
        if (this.session.isZoningEnabled()) {
            this.zoneUIN = this.zoneSelector.getZoneUIN();
        }
        this.showAgain = this.enableShowAgainFlag ? this.checkCreateAnother.getSelection() : false;
        super.okPressed();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectAlias() {
        return this.objectAlias;
    }

    public void setObjectAlias(String objectAlias) {
        this.objectAlias = objectAlias;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getCreationFlags() {
        return this.creationFlags;
    }

    public long getAgentProxy() {
        return this.agentProxy;
    }

    public long getSnmpProxy() {
        return this.snmpProxy;
    }

    public long getEtherNetIpProxy() {
        return this.etherNetIpProxy;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public long getIcmpProxy() {
        return this.icmpProxy;
    }

    public long getSshProxy() {
        return this.sshProxy;
    }

    public long getWebServiceProxy() {
        return this.webServiceProxy;
    }

    public int getZoneUIN() {
        return this.zoneUIN;
    }

    public void setZoneUIN(int zoneUIN) {
        this.zoneUIN = zoneUIN;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public int getSnmpPort() {
        return this.snmpPort;
    }

    public int getEtherNetIpPort() {
        return this.etherNetIpPort;
    }

    public String getSshLogin() {
        return this.sshLogin;
    }

    public String getSshPassword() {
        return this.sshPassword;
    }

    public boolean isShowAgain() {
        return this.showAgain;
    }

    public boolean isEnableShowAgainFlag() {
        return this.enableShowAgainFlag;
    }

    public void setEnableShowAgainFlag(boolean enableShowAgainFlag) {
        this.enableShowAgainFlag = enableShowAgainFlag;
    }
}

