/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.Sensor;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.modules.objects.ObjectContextMenuManager;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.widgets.AbstractObjectStatusMap;
import org.netxms.nxmc.tools.RefreshTimer;
import org.netxms.nxmc.tools.WidgetHelper;

public abstract class AbstractObjectStatusMap
extends Composite
implements ISelectionProvider {
    protected ObjectView view;
    protected NXCSession session;
    protected ISelection selection = null;
    protected Set<ISelectionChangedListener> selectionListeners = new HashSet();
    protected MenuManager menuManager;
    protected int severityFilter = 255;
    protected String textFilter = "";
    protected boolean hideObjectsInMaintenance = false;
    protected Set<Runnable> refreshListeners = new HashSet();
    protected RefreshTimer refreshTimer;
    protected boolean fitToScreen;
    private Composite content;
    private ScrolledComposite scroller;

    public AbstractObjectStatusMap(ObjectView view, Composite parent, int style) {
        super(parent, style);
        this.view = view;
        this.session = Registry.getSession();
        1 sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener((SessionListener)sessionListener);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setLayout((Layout)new FillLayout());
        this.setBackground(this.getDisplay().getSystemColor(25));
        this.scroller = new ScrolledComposite((Composite)this, 768);
        this.scroller.setBackground(this.getBackground());
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        this.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)30);
        this.menuManager = new ObjectContextMenuManager((View)view, (ISelectionProvider)this, null);
        this.content = this.createContent((Composite)this.scroller);
        this.scroller.setContent((Control)this.content);
        this.refreshTimer = new RefreshTimer(10000, (Control)this, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected abstract Composite createContent(Composite var1);

    protected boolean isAcceptedByFilter(AbstractObject object) {
        if ((1 << object.getStatus().getValue() & this.severityFilter) == 0) {
            return false;
        }
        if (this.hideObjectsInMaintenance && object.isInMaintenanceMode()) {
            return false;
        }
        if (!this.textFilter.isEmpty()) {
            boolean match = false;
            for (String s : object.getStrings()) {
                if (!s.toLowerCase().contains(this.textFilter)) continue;
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
        }
        return true;
    }

    protected void filterObjects(Collection<AbstractObject> objects) {
        if ((this.severityFilter & 0x3F) == 63 && !this.hideObjectsInMaintenance && this.textFilter.isEmpty()) {
            return;
        }
        Iterator<AbstractObject> it = objects.iterator();
        while (it.hasNext()) {
            AbstractObject o = it.next();
            if (this.isAcceptedByFilter(o)) continue;
            it.remove();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener l : this.selectionListeners) {
            l.selectionChanged(event);
        }
    }

    protected void showObjectDetails(AbstractObject object) {
    }

    public String getTextFilter() {
        return this.textFilter;
    }

    public void setTextFilter(String textFilter) {
        this.textFilter = textFilter != null ? textFilter.strip().toLowerCase() : "";
    }

    public int getSeverityFilter() {
        return this.severityFilter;
    }

    public void setSeverityFilter(int severityFilter) {
        this.severityFilter = severityFilter;
    }

    public boolean isHideObjectsInMaintenance() {
        return this.hideObjectsInMaintenance;
    }

    public void setHideObjectsInMaintenance(boolean hideObjectsInMaintenance) {
        this.hideObjectsInMaintenance = hideObjectsInMaintenance;
    }

    public void addRefreshListener(Runnable listener) {
        this.refreshListeners.add(listener);
    }

    public void removeRefreshListener(Runnable listener) {
        this.refreshListeners.remove(listener);
    }

    public abstract void refresh();

    protected abstract void onObjectChange(AbstractObject var1);

    protected abstract void onObjectDelete(long var1);

    protected abstract Point computeSize();

    protected static boolean isContainerObject(AbstractObject object) {
        return object instanceof Container || object instanceof Cluster || object instanceof Rack || object instanceof Chassis;
    }

    protected static boolean isLeafObject(AbstractObject object) {
        return object instanceof Node || object instanceof MobileDevice || object instanceof Sensor;
    }

    public void setFitToScreen(boolean fitToScreen) {
        this.fitToScreen = fitToScreen;
        this.refresh();
        this.updateScrollBars();
    }

    protected void updateScrollBars() {
        this.scroller.setMinSize(this.computeSize());
    }

    protected Rectangle getAvailableClientArea() {
        Rectangle rect = this.scroller.getClientArea();
        ScrollBar sb = this.scroller.getVerticalBar();
        if (sb != null) {
            rect.width -= sb.getSize().x;
        }
        if ((sb = this.scroller.getHorizontalBar()) != null) {
            rect.height -= sb.getSize().y;
        }
        return rect;
    }
}

