/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.worldmap.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.netxms.base.GeoLocation;
import org.netxms.base.VersionInfo;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.modules.worldmap.GeoLocationCache;
import org.netxms.nxmc.modules.worldmap.tools.Area;
import org.netxms.nxmc.modules.worldmap.tools.Tile;
import org.netxms.nxmc.modules.worldmap.tools.TileSet;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MapLoader {
    private static final Logger logger = LoggerFactory.getLogger(MapLoader.class);
    public static final int CENTER = 0;
    public static final int TOP_LEFT = 1;
    public static final int BOTTOM_RIGHT = 2;
    private static Object CACHE_MUTEX = new Object();
    private Display display;
    private NXCSession session;
    private ExecutorService workers;
    private Image missingTile = null;
    private Image loadingTile = null;
    private Image borderTile = null;

    public MapLoader(Display display) {
        this.display = display;
        this.missingTile = ResourceManager.getImage((Display)display, (String)"icons/worldmap/missing_tile.png");
        this.loadingTile = ResourceManager.getImage((Display)display, (String)"icons/worldmap/loading_tile.png");
        this.borderTile = ResourceManager.getImage((Display)display, (String)"icons/worldmap/border_tile.png");
        this.session = Registry.getSession();
        this.workers = Executors.newFixedThreadPool(16, (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static Point tileFromLocation(double lat, double lon, int zoom) {
        int x = (int)Math.floor((lon + 180.0) / 360.0 * (double)(1 << zoom));
        int y = (int)Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)(1 << zoom));
        return new Point(x, y);
    }

    private static double longitudeFromTile(int x, int z) {
        return (double)x / Math.pow(2.0, z) * 360.0 - 180.0;
    }

    private static double latitudeFromTile(int y, int z) {
        double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, z);
        return Math.toDegrees(Math.atan(Math.sinh(n)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image loadTile(int zoom, int x, int y) {
        String tileServerURL = this.session.getTileServerURL();
        URL url = null;
        try {
            url = new URL(tileServerURL + zoom + "/" + x + "/" + y + ".png");
        }
        catch (MalformedURLException e) {
            logger.warn("Invalid tile server URL", (Throwable)e);
            return null;
        }
        HttpURLConnection conn = null;
        InputStream in = null;
        Image image = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("User-Agent", "nxmc/" + VersionInfo.version());
            conn.setAllowUserInteraction(false);
            in = new BufferedInputStream(conn.getInputStream());
            image = WidgetHelper.createImageFromStream((Display)this.display, (InputStream)in);
        }
        catch (IOException e) {
            logger.warn(url.toString() + ": " + e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (IOException e) {}
        }
        if (image != null) {
            File imageFile = this.buildCacheFileName(zoom, x, y);
            Object object = CACHE_MUTEX;
            synchronized (object) {
                imageFile.getParentFile().mkdirs();
            }
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{image.getImageData()};
            Object object2 = CACHE_MUTEX;
            synchronized (object2) {
                imageLoader.save(imageFile.getAbsolutePath(), 5);
            }
        }
        return image;
    }

    private File buildCacheFileName(int zoom, int x, int y) {
        StringBuilder sb = new StringBuilder("MapTiles");
        sb.append(File.separatorChar);
        sb.append(zoom);
        sb.append(File.separatorChar);
        sb.append(x);
        sb.append(File.separatorChar);
        sb.append(y);
        sb.append(".png");
        return new File(Registry.getStateDir((Display)this.display), sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image loadTileFromCache(int zoom, int x, int y) {
        try {
            File imageFile = this.buildCacheFileName(zoom, x, y);
            ImageData[] imageData = null;
            Object object = CACHE_MUTEX;
            synchronized (object) {
                if (!imageFile.canRead()) {
                    return null;
                }
                ImageLoader imageLoader = new ImageLoader();
                imageData = imageLoader.load(imageFile.getAbsolutePath());
            }
            return WidgetHelper.createImageFromImageData((Display)this.display, (ImageData)imageData[0]);
        }
        catch (Exception e) {
            logger.error("Exception in loadTileFromCache", (Throwable)e);
            return null;
        }
    }

    public Tile getTile(int zoom, int x, int y, boolean cachedOnly) {
        int maxTileNum = (1 << zoom) - 1;
        if (y < 0 || y > maxTileNum) {
            return new Tile(x, y, this.borderTile, true, true);
        }
        if (x < 0) {
            x = maxTileNum + 1 - -x % (maxTileNum + 1);
        } else if (x > maxTileNum) {
            x %= maxTileNum + 1;
        }
        Image tileImage = this.loadTileFromCache(zoom, x, y);
        if (tileImage == null) {
            if (cachedOnly) {
                return new Tile(x, y, this.loadingTile, false, true);
            }
            tileImage = this.loadTile(zoom, x, y);
        }
        return tileImage != null ? new Tile(x, y, tileImage, true, false) : new Tile(x, y, this.missingTile, true, true);
    }

    public static Rectangle calculateBoundingBox(Point mapSize, GeoLocation centerPoint, int zoom) {
        Area coverage = GeoLocationCache.calculateCoverage((Point)mapSize, (GeoLocation)centerPoint, (int)0, (int)zoom);
        Point topLeft = MapLoader.tileFromLocation((double)coverage.getxLow(), (double)coverage.getyLow(), (int)zoom);
        Point bottomRight = MapLoader.tileFromLocation((double)coverage.getxHigh(), (double)coverage.getyHigh(), (int)zoom);
        return new Rectangle(topLeft.x, topLeft.y, bottomRight.x, bottomRight.y);
    }

    public TileSet getAllTiles(Point mapSize, GeoLocation basePoint, int pointLocation, int zoom, boolean cachedOnly) {
        if (mapSize.x < 32 || mapSize.y < 32 || basePoint == null) {
            return null;
        }
        Area coverage = GeoLocationCache.calculateCoverage((Point)mapSize, (GeoLocation)basePoint, (int)pointLocation, (int)zoom);
        Point bottomLeft = MapLoader.tileFromLocation((double)coverage.getxLow(), (double)coverage.getyLow(), (int)zoom);
        Point topRight = MapLoader.tileFromLocation((double)coverage.getxHigh(), (double)coverage.getyHigh(), (int)zoom);
        Tile[][] tiles = new Tile[bottomLeft.y - topRight.y + 1][topRight.x - bottomLeft.x + 1];
        int x = bottomLeft.x;
        int y = topRight.y;
        int l = (bottomLeft.y - topRight.y + 1) * (topRight.x - bottomLeft.x + 1);
        for (int i = 0; i < l; ++i) {
            tiles[y - topRight.y][x - bottomLeft.x] = this.getTile(zoom, x, y, cachedOnly);
            if (++x <= topRight.x) continue;
            x = bottomLeft.x;
            ++y;
        }
        double lat = MapLoader.latitudeFromTile((int)topRight.y, (int)zoom);
        double lon = MapLoader.longitudeFromTile((int)bottomLeft.x, (int)zoom);
        Point realTopLeft = GeoLocationCache.coordinateToDisplay((GeoLocation)new GeoLocation(lat, lon), (int)zoom);
        Point reqTopLeft = GeoLocationCache.coordinateToDisplay((GeoLocation)new GeoLocation(coverage.getxHigh(), coverage.getyLow()), (int)zoom);
        return new TileSet(tiles, realTopLeft.x - reqTopLeft.x, realTopLeft.y - reqTopLeft.y, zoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMissingTiles(TileSet tiles, Runnable progressHandler) {
        TileSet tileSet = tiles;
        synchronized (tileSet) {
            tiles.lastProgressUpdate = System.currentTimeMillis();
            for (int i = 0; i < tiles.tiles.length; ++i) {
                for (int j = 0; j < tiles.tiles[i].length; ++j) {
                    Tile tile = tiles.tiles[i][j];
                    if (tile.isLoaded()) continue;
                    ++tiles.workers;
                    int row = i;
                    int col = j;
                    this.workers.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                }
            }
            while (tiles.workers > 0) {
                try {
                    tiles.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.display.asyncExec(progressHandler);
    }

    protected boolean isInternalImage(Image image) {
        return image == this.missingTile || image == this.borderTile || image == this.loadingTile;
    }

    public void dispose() {
        this.workers.shutdown();
        if (this.loadingTile != null) {
            this.loadingTile.dispose();
        }
        if (this.missingTile != null) {
            this.missingTile.dispose();
        }
        if (this.borderTile != null) {
            this.borderTile.dispose();
        }
    }
}

