/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GeoLocationControlMode {
    NO_CONTROL(0),
    RESTRICTED_AREAS(1),
    ALLOWED_AREAS(2);

    private static Logger logger;
    private static Map<Integer, GeoLocationControlMode> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(GeoLocationControlMode.class);
        lookupTable = new HashMap<Integer, GeoLocationControlMode>();
        GeoLocationControlMode[] geoLocationControlModeArray = GeoLocationControlMode.values();
        int n = geoLocationControlModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GeoLocationControlMode element = geoLocationControlModeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private GeoLocationControlMode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static GeoLocationControlMode getByValue(int value) {
        GeoLocationControlMode element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return NO_CONTROL;
        }
        return element;
    }
}

