/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.AbstractDCIPropertyPage;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class OtherOptions
extends AbstractDCIPropertyPage {
    private DataCollectionItem dci;
    private Button checkShowOnTooltip;
    private Button checkShowInOverview;
    private Button checkCalculateStatus;
    private Button checkHideOnLastValues;
    private Combo multiplierDegree;
    private Combo agentCacheMode;
    private ObjectSelector relatedObject;

    @Override
    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsItem();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkShowOnTooltip = new Button(dialogArea, 32);
        Messages.get();
        this.checkShowOnTooltip.setText(Messages.NetworkMaps_ShowInTooltips);
        this.checkShowOnTooltip.setSelection(this.dci.isShowOnObjectTooltip());
        this.checkShowInOverview = new Button(dialogArea, 32);
        Messages.get();
        this.checkShowInOverview.setText(Messages.OtherOptions_ShowlastValueInObjectOverview);
        this.checkShowInOverview.setSelection(this.dci.isShowInObjectOverview());
        this.checkCalculateStatus = new Button(dialogArea, 32);
        Messages.get();
        this.checkCalculateStatus.setText(Messages.OtherOptions_UseForStatusCalculation);
        this.checkCalculateStatus.setSelection(this.dci.isUsedForNodeStatusCalculation());
        this.checkHideOnLastValues = new Button(dialogArea, 32);
        this.checkHideOnLastValues.setText("Hide value on \"Last Values\" page");
        this.checkHideOnLastValues.setSelection(this.dci.isHideOnLastValuesView());
        Messages.get();
        this.agentCacheMode = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.General_AgentCacheMode, (Object)new GridData());
        Messages.get();
        this.agentCacheMode.add(Messages.General_Default);
        Messages.get();
        this.agentCacheMode.add(Messages.General_On);
        Messages.get();
        this.agentCacheMode.add(Messages.General_Off);
        this.agentCacheMode.select(this.dci.getCacheMode().getValue());
        this.multiplierDegree = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Multiplier degree", (Object)new GridData());
        this.multiplierDegree.add("Fixed to P");
        this.multiplierDegree.add("Fixed to T");
        this.multiplierDegree.add("Fixed to G");
        this.multiplierDegree.add("Fixed to M");
        this.multiplierDegree.add("Fixed to K");
        this.multiplierDegree.add("Default");
        this.multiplierDegree.add("Fixed to m");
        this.multiplierDegree.add("Fixed to \u00ce\u00bc");
        this.multiplierDegree.add("Fixed to n");
        this.multiplierDegree.add("Fixed to p");
        this.multiplierDegree.add("Fixed to f");
        this.multiplierDegree.select(5 - this.dci.getMultiplier());
        this.relatedObject = new ObjectSelector(dialogArea, 0, true);
        this.relatedObject.setLabel("Related object");
        this.relatedObject.setObjectClass(GenericObject.class);
        this.relatedObject.setObjectId(this.dci.getRelatedObject());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.relatedObject.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void applyChanges(boolean isApply) {
        this.dci.setShowOnObjectTooltip(this.checkShowOnTooltip.getSelection());
        this.dci.setShowInObjectOverview(this.checkShowInOverview.getSelection());
        this.dci.setUsedForNodeStatusCalculation(this.checkCalculateStatus.getSelection());
        this.dci.setHideOnLastValuesView(this.checkHideOnLastValues.getSelection());
        this.dci.setCacheMode(AgentCacheMode.getByValue((int)this.agentCacheMode.getSelectionIndex()));
        this.dci.setMultiplier(5 - this.multiplierDegree.getSelectionIndex());
        this.dci.setRelatedObject(this.relatedObject.getObjectId());
        this.editor.modify();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.checkShowOnTooltip.setSelection(false);
        this.checkShowInOverview.setSelection(false);
        this.checkCalculateStatus.setSelection(false);
        this.checkHideOnLastValues.setSelection(false);
        this.agentCacheMode.select(0);
        this.multiplierDegree.select(0);
        this.relatedObject.setObjectId(0L);
    }
}

