/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.WebServiceDefinition;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.pages.WebServiceGeneral;
import org.netxms.ui.eclipse.datacollection.dialogs.pages.WebServiceHeaders;
import org.netxms.ui.eclipse.datacollection.views.helpers.WebServiceDefinitionComparator;
import org.netxms.ui.eclipse.datacollection.views.helpers.WebServiceDefinitionFilter;
import org.netxms.ui.eclipse.datacollection.views.helpers.WebServiceDefinitionLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class WebServiceManager
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.datacollection.views.WebServiceManager";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_URL = 1;
    public static final int COLUMN_METHOD = 2;
    public static final int COLUMN_AUTHENTICATION = 4;
    public static final int COLUMN_LOGIN = 5;
    public static final int COLUMN_RETENTION_TIME = 6;
    public static final int COLUMN_TIMEOUT = 7;
    public static final int COLUMN_DESCRIPTION = 8;
    private Map<Integer, WebServiceDefinition> webServiceDefinitions = new HashMap<Integer, WebServiceDefinition>();
    private int nameCounter = 1;
    private Composite content;
    private FilterText filterText;
    private WebServiceDefinitionFilter filter;
    private SortableTableViewer viewer;
    private Action actionCreate;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionShowFilter;
    private RefreshAction actionRefresh;

    public void createPartControl(Composite parent) {
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this.content, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebServiceManager.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                WebServiceManager.this.enableFilter(false);
                WebServiceManager.this.actionShowFilter.setChecked(false);
            }
        });
        String[] names = new String[]{"Name", "URL", "Method", "Authentication", "Login", "Retention Time", "Timeout", "Description"};
        int[] widths = new int[]{300, 600, 100, 100, 160, 90, 90, 600};
        this.viewer = new SortableTableViewer(this.content, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WebServiceDefinitionLabelProvider());
        this.viewer.setComparator((ViewerComparator)new WebServiceDefinitionComparator());
        this.filter = new WebServiceDefinitionFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"WebServiceManager");
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)WebServiceManager.this.viewer.getSelection();
                WebServiceManager.this.actionEdit.setEnabled(selection.size() == 1);
                WebServiceManager.this.actionDelete.setEnabled(!selection.isEmpty());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WebServiceManager.this.editDefinition();
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)WebServiceManager.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"WebServiceManager");
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.activateContext();
        this.refresh();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.datacollection.context.WebServiceManager");
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                WebServiceManager.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction(){

            public void run() {
                WebServiceManager.this.refresh();
            }
        };
        this.actionCreate = new Action("&New...", SharedIcons.ADD_OBJECT){

            public void run() {
                WebServiceManager.this.createDefinition();
            }
        };
        Messages.get();
        this.actionEdit = new Action(Messages.DataCollectionEditor_ActionEdit, SharedIcons.EDIT){

            public void run() {
                WebServiceManager.this.editDefinition();
            }
        };
        Messages.get();
        this.actionEdit.setText(Messages.DataCollectionEditor_Edit);
        this.actionEdit.setImageDescriptor(Activator.getImageDescriptor("icons/edit.png"));
        this.actionEdit.setEnabled(false);
        Messages.get();
        this.actionDelete = new Action(Messages.DataCollectionEditor_Delete, SharedIcons.DELETE_OBJECT){

            public void run() {
                WebServiceManager.this.deleteDefinitions();
            }
        };
        this.actionDelete.setEnabled(false);
        Messages.get();
        this.actionShowFilter = new Action(Messages.DataCollectionEditor_ShowFilter, 2){

            public void run() {
                WebServiceManager.this.enableFilter(WebServiceManager.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.getBooleanFromSettings("WebServiceManager.showFilter", true));
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.datacollection.commands.show_websvc_filter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
    }

    private boolean getBooleanFromSettings(String name, boolean defval) {
        String v = Activator.getDefault().getDialogSettings().get(name);
        return v != null ? Boolean.valueOf(v) : defval;
    }

    private void refresh() {
        final NXCSession session = ConsoleSharedData.getSession();
        ConsoleJob job = new ConsoleJob("Loading web service definitions", (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List definitions = session.getWebServiceDefinitions();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).WebServiceManager.this.webServiceDefinitions.clear();
                        for (WebServiceDefinition d : definitions) {
                            (this).WebServiceManager.this.webServiceDefinitions.put(d.getId(), d);
                        }
                        (this).WebServiceManager.this.viewer.setInput((this).WebServiceManager.this.webServiceDefinitions.values());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot load web service definitions";
            }
        };
        job.start();
    }

    private void createDefinition() {
        WebServiceDefinition definition;
        if (this.showDefinitionEditDialog(definition = new WebServiceDefinition("Web Service " + Integer.toString(this.nameCounter++)))) {
            final NXCSession session = ConsoleSharedData.getSession();
            new ConsoleJob("Creating web service definition", (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection"){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    definition.setId(session.modifyWebServiceDefinition(definition));
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).WebServiceManager.this.webServiceDefinitions.put(definition.getId(), definition);
                            (this).WebServiceManager.this.viewer.refresh();
                        }
                    });
                }

                protected String getErrorMessage() {
                    return "Cannot create web service definition";
                }
            }.start();
        }
    }

    private void editDefinition() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        final WebServiceDefinition definition = (WebServiceDefinition)selection.getFirstElement();
        if (this.showDefinitionEditDialog(definition)) {
            final NXCSession session = ConsoleSharedData.getSession();
            new ConsoleJob("Updating web service definition", (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection"){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    session.modifyWebServiceDefinition(definition);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).WebServiceManager.this.viewer.refresh();
                        }
                    });
                }

                protected String getErrorMessage() {
                    return "Cannot update web service definition";
                }
            }.start();
        }
    }

    private boolean showDefinitionEditDialog(WebServiceDefinition definition) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new WebServiceGeneral(definition)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("headers", (IPreferencePage)new WebServiceHeaders(definition)));
        PreferenceDialog dlg = new PreferenceDialog(this.getViewSite().getShell(), pm){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText("Edit Web Service Definition");
            }
        };
        dlg.setBlockOnOpen(true);
        return dlg.open() == 0;
    }

    private void deleteDefinitions() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Delete Web Service Definitions", (String)"Selected web service definitions will be permanently deleted. Are you sure?")) {
            return;
        }
        final int[] deleteList = new int[selection.size()];
        int index = 0;
        for (Object o : selection.toList()) {
            deleteList[index++] = ((WebServiceDefinition)o).getId();
        }
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Delete web service definitions", (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int[] nArray = deleteList;
                int n = deleteList.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    session.deleteWebServiceDefinition(id);
                    ++n2;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        int[] nArray = deleteList;
                        int n = deleteList.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int id = nArray[n2];
                            (this).WebServiceManager.this.webServiceDefinitions.remove(id);
                            ++n2;
                        }
                        (this).WebServiceManager.this.viewer.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot delete web service definition";
            }
        }.start();
    }

    private void enableFilter(boolean enable) {
        this.filterText.setVisible(enable);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.content.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
        Activator.getDefault().getDialogSettings().put("WebServiceManager.showFilter", enable);
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }
}

