/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ObjectFigure;

public class ObjectFloorPlan
extends ObjectFigure {
    private static final int MARGIN_X = 3;
    private static final int MARGIN_Y = 3;
    private static final int TOP_LEFT = 0;
    private static final int TOP_RIGHT = 1;
    private static final int BOTTOM_LEFT = 2;
    private static final int BOTTOM_RIGHT = 3;
    private NetworkMapObject element;
    private boolean resize = true;
    private Label label;
    private int lastX;
    private int lastY;

    public ObjectFloorPlan(NetworkMapObject element, MapLabelProvider labelProvider) {
        super(element, labelProvider);
        this.element = element;
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.setSize(element.getWidth(), element.getHeight());
        this.label = new Label(this.object.getNameOnMap());
        this.label.setFont(labelProvider.getTitleFont());
        this.label.setLabelAlignment(2);
        this.add((IFigure)this.label);
        Dimension d = this.label.getPreferredSize();
        this.label.setSize(d);
        this.label.setLocation(new Point(element.getWidth() / 2 - d.width / 2, element.getHeight() / 2 - d.height / 2));
        this.setBackgroundColor(StatusDisplayInfo.getStatusColor((ObjectStatus)this.object.getStatus()));
        this.createResizeHandle(3);
    }

    private void createResizeHandle(int pos) {
        final Figure handle = new Figure();
        this.add((IFigure)handle);
        Dimension size = this.getSize();
        handle.setSize(8, 8);
        switch (pos) {
            case 0: {
                handle.setLocation(new Point(-1, -1));
                handle.setCursor(Display.getCurrent().getSystemCursor(8));
                break;
            }
            case 1: {
                handle.setLocation(new Point(size.width - 7, -1));
                handle.setCursor(Display.getCurrent().getSystemCursor(6));
                break;
            }
            case 2: {
                handle.setLocation(new Point(-1, size.height - 7));
                handle.setCursor(Display.getCurrent().getSystemCursor(6));
                break;
            }
            case 3: {
                handle.setLocation(new Point(size.width - 7, size.height - 7));
                handle.setCursor(Display.getCurrent().getSystemCursor(8));
            }
        }
        handle.addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent me) {
                if (ObjectFloorPlan.this.resize) {
                    ObjectFloorPlan.this.resize = false;
                    Dimension size = ObjectFloorPlan.this.getSize();
                    ObjectFloorPlan.this.element.setSize(size.width, size.height);
                }
            }

            public void mousePressed(MouseEvent me) {
                if (me.button == 1) {
                    ObjectFloorPlan.this.resize = true;
                    ObjectFloorPlan.this.lastX = me.x;
                    ObjectFloorPlan.this.lastY = me.y;
                    me.consume();
                }
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }
        });
        handle.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent me) {
            }

            public void mouseHover(MouseEvent me) {
            }

            public void mouseExited(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
            }

            public void mouseDragged(MouseEvent me) {
                if (ObjectFloorPlan.this.resize) {
                    Dimension size = ObjectFloorPlan.this.getSize();
                    int dx = me.x - ObjectFloorPlan.this.lastX;
                    int dy = me.y - ObjectFloorPlan.this.lastY;
                    if (dx < 0 && size.width <= 40) {
                        dx = 0;
                    }
                    if (dy < 0 && size.height <= 20) {
                        dy = 0;
                    }
                    size.width += dx;
                    size.height += dy;
                    ObjectFloorPlan.this.setSize(size);
                    Point p = handle.getLocation();
                    p.performTranslate(dx, dy);
                    handle.setLocation(p);
                    ObjectFloorPlan.this.lastX = me.x;
                    ObjectFloorPlan.this.lastY = me.y;
                    me.consume();
                    Dimension d = ObjectFloorPlan.this.label.getPreferredSize();
                    p = ObjectFloorPlan.this.getLocation();
                    ObjectFloorPlan.this.label.setLocation(new Point(p.x + size.width / 2 - d.width / 2, p.y + size.height / 2 - d.height / 2));
                }
            }
        });
    }

    protected void paintFigure(Graphics gc) {
        gc.setAntialias(1);
        Rectangle rect = new Rectangle(this.getBounds());
        ++rect.x;
        ++rect.y;
        rect.width -= 3;
        rect.height -= 3;
        gc.setAlpha(255);
        gc.setForegroundColor(this.isElementSelected() ? SELECTION_COLOR : StatusDisplayInfo.getStatusColor((ObjectStatus)this.object.getStatus()));
        gc.setLineWidth(3);
        gc.setLineStyle(this.isElementSelected() ? 3 : 1);
        gc.drawRoundRectangle(rect, 8, 8);
        if (!this.labelProvider.isTranslucentLabelBackground()) {
            gc.setBackgroundColor(SOLID_WHITE);
            gc.fillRoundRectangle(this.getBounds(), 8, 8);
        }
        gc.setBackgroundColor(this.isElementSelected() ? SELECTION_COLOR : StatusDisplayInfo.getStatusColor((ObjectStatus)this.object.getStatus()));
        gc.setAlpha(32);
        gc.fillRoundRectangle(this.getBounds(), 8, 8);
    }
}

