/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netxms.base.MacAddressFormatException;

public class MacAddress {
    private byte[] value;

    public MacAddress() {
        this.value = new byte[6];
        Arrays.fill(this.value, (byte)0);
    }

    public MacAddress(byte[] src) {
        if (src != null && src.length > 0) {
            this.value = Arrays.copyOf(src, src.length);
        } else {
            this.value = new byte[6];
            Arrays.fill(this.value, (byte)0);
        }
    }

    public MacAddress(byte[] src, int len) {
        if (src != null && src.length > 0) {
            this.value = Arrays.copyOf(src, Integer.min(src.length, len));
        } else {
            this.value = new byte[6];
            Arrays.fill(this.value, (byte)0);
        }
    }

    public boolean isNull() {
        byte[] byArray = this.value;
        int n = this.value.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int ub = this.value[0] & 0xFF;
        if (ub < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(ub));
        int i = 1;
        while (i < this.value.length) {
            sb.append(':');
            ub = this.value[i] & 0xFF;
            if (ub < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(ub));
            ++i;
        }
        return sb.toString().toUpperCase();
    }

    public boolean equals(Object other) {
        if (other instanceof MacAddress) {
            return Arrays.equals(this.value, ((MacAddress)other).value);
        }
        return super.equals(other);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public static MacAddress parseMacAddress(String str) throws MacAddressFormatException {
        return MacAddress.parseMacAddress(str, true);
    }

    public static MacAddress parseMacAddress(String str, boolean fullMac) throws MacAddressFormatException {
        Pattern pattern = fullMac ? Pattern.compile("^([0-9a-fA-F]{2})[ :-]?([0-9a-fA-F]{2})[ .:-]?([0-9a-fA-F]{2})[ :-]?([0-9a-fA-F]{2})[ .:-]?([0-9a-fA-F]{2})[ :-]?([0-9a-fA-F]{2})[ .:-]?([0-9a-fA-F]{2})?[ :-]?([0-9a-fA-F]{2})?$") : Pattern.compile("^([0-9a-fA-F]{2})[ :-]?([0-9a-fA-F]{2})[ .:-]?([0-9a-fA-F]{2})?[ :-]?([0-9a-fA-F]{2})?[ .:-]?([0-9a-fA-F]{2})?[ :-]?([0-9a-fA-F]{2})?[ .:-]?([0-9a-fA-F]{2})?[ :-]?([0-9a-fA-F]{2})?$");
        Matcher matcher = pattern.matcher(str.trim());
        if (matcher.matches()) {
            int count = matcher.groupCount();
            ArrayList<Byte> byteList = new ArrayList<Byte>();
            try {
                int i = 0;
                while (i < count) {
                    if (matcher.group(i + 1) != null) {
                        byteList.add((byte)Integer.parseInt(matcher.group(i + 1), 16));
                    }
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                throw new MacAddressFormatException();
            }
            byte[] bytes = new byte[byteList.size()];
            int i = 0;
            while (i < byteList.size()) {
                bytes[i] = (Byte)byteList.get(i);
                ++i;
            }
            return new MacAddress(bytes);
        }
        pattern = fullMac ? Pattern.compile("^([0-9a-fA-F]{3})\\.([0-9a-fA-F]{3})\\.([0-9a-fA-F]{3})\\.([0-9a-fA-F]{3})$") : Pattern.compile("^([0-9a-fA-F]{3})\\.([0-9a-fA-F]{3})\\.([0-9a-fA-F]{3})\\.([0-9a-fA-F]{3})$|^([0-9a-fA-F]{3})\\.([0-9a-fA-F]{3})$");
        matcher = pattern.matcher(str.trim());
        if (matcher.matches()) {
            int i;
            int count = matcher.groupCount();
            ArrayList<Byte> byteList = new ArrayList<Byte>();
            try {
                int j = 0;
                i = 1;
                while (i <= count) {
                    int left = Integer.parseInt(matcher.group(i), 16);
                    int right = Integer.parseInt(matcher.group(i + 1), 16);
                    byteList.add(j++, (byte)(left >> 4));
                    byteList.add(j++, (byte)((left & 0xF) << 4 | right >> 8));
                    byteList.add(j++, (byte)(right & 0xFF));
                    i += 2;
                }
            }
            catch (NumberFormatException e) {
                throw new MacAddressFormatException();
            }
            byte[] bytes = new byte[byteList.size()];
            i = 0;
            while (i < byteList.size()) {
                bytes[i] = (Byte)byteList.get(i);
                ++i;
            }
            return new MacAddress(bytes);
        }
        throw new MacAddressFormatException();
    }

    public byte[] getValue() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    public int compareTo(MacAddress dst) {
        if (dst == null) {
            return 1;
        }
        int len = Math.min(this.value.length, dst.value.length);
        int i = 0;
        while (i < len) {
            int v1 = this.value[i] & 0xFF;
            int v2 = dst.value[i] & 0xFF;
            if (v1 < v2) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            ++i;
        }
        return this.value.length - dst.value.length;
    }
}

