/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TwoFactorMetodSelectionDialog
extends Dialog {
    private TableViewer viewer;
    private List<String> methods;
    private int selectedMethod = -1;

    public TwoFactorMetodSelectionDialog(Shell parentShell, List<String> methods) {
        super(parentShell);
        this.methods = methods;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Two-factor Authentication");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 16384);
        label.setText("Enhanced security is enabled for your account.\r\nChoose a second factor for authentication:");
        this.viewer = new TableViewer(dialogArea, 2048);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((String)e1).compareToIgnoreCase((String)e2);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (TwoFactorMetodSelectionDialog.this.getButton(0).isEnabled()) {
                    TwoFactorMetodSelectionDialog.this.okPressed();
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TwoFactorMetodSelectionDialog.this.getButton(0).setEnabled(!TwoFactorMetodSelectionDialog.this.viewer.getSelection().isEmpty());
            }
        });
        this.viewer.setInput(this.methods);
        return dialogArea;
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        this.getButton(0).setEnabled(false);
        return content;
    }

    protected void okPressed() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        this.selectedMethod = this.methods.indexOf((String)selection.getFirstElement());
        super.okPressed();
    }

    public int getSelectedMethod() {
        return this.selectedMethod;
    }
}

