/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.slm.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.slm.propertypages.InstanceDiscovery;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class CreateBusinessServicePrototypeDialog
extends Dialog {
    private LabeledText nameField;
    private LabeledText aliasField;
    private Combo instanceDiscoveyMethodCombo;
    private String name;
    private String alias;
    private String instanceDiscoveyMethod;

    public CreateBusinessServicePrototypeDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create Business Service Prototype");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.nameField = new LabeledText(dialogArea, 0);
        this.nameField.setLabel("Name");
        this.nameField.getTextControl().setTextLimit(63);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.nameField.setLayoutData((Object)gd);
        this.aliasField = new LabeledText(dialogArea, 0);
        this.aliasField.setLabel("Alias");
        this.aliasField.getTextControl().setTextLimit(63);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.aliasField.setLayoutData((Object)gd);
        this.instanceDiscoveyMethodCombo = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Instance discovery type", (Object)new GridData(4, 0x1000000, true, false));
        for (String type : InstanceDiscovery.DISCOVERY_TYPES) {
            if (type == null) continue;
            this.instanceDiscoveyMethodCombo.add(type);
        }
        this.instanceDiscoveyMethodCombo.select(0);
        return dialogArea;
    }

    protected void okPressed() {
        this.instanceDiscoveyMethod = this.instanceDiscoveyMethodCombo.getText();
        this.name = this.nameField.getText().trim();
        if (this.name.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Object name cannot be empty");
            return;
        }
        this.alias = this.aliasField.getText().trim();
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public int getInstanceDiscoveyMethod() {
        return InstanceDiscovery.DISCOVERY_TYPES.indexOf(this.instanceDiscoveyMethod);
    }
}

