/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.HistoricalDataType;
import org.netxms.client.constants.TimeUnit;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.MeasurementUnit;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.charts.api.ChartType;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.LineChartConfig;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.views.HistoricalGraphView;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ViewRefreshController;

public class LineChartElement
extends ElementWidget
implements HistoricalGraphView.HistoricalChartOwner {
    private Chart chart;
    private LineChartConfig config;
    private ViewRefreshController refreshController;
    private boolean updateInProgress = false;
    private NXCSession session;
    private List<ChartDciConfig> runtimeDciList = new ArrayList<ChartDciConfig>();
    private List<DataCacheElement> dataCache = new ArrayList<DataCacheElement>(16);
    private Action actionRefresh;
    private Action actionAdjustX;
    private Action actionAdjustY;
    private Action actionAdjustBoth;
    private Action[] presetActions;

    public LineChartElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        this.session = ConsoleSharedData.getSession();
        try {
            this.config = LineChartConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new LineChartConfig();
        }
        this.processCommonSettings(this.config);
        ChartConfiguration chartConfig = new ChartConfiguration();
        chartConfig.setZoomEnabled(this.config.isInteractive());
        chartConfig.setTitleVisible(false);
        chartConfig.setLegendVisible(this.config.isShowLegend());
        chartConfig.setLegendPosition(this.config.getLegendPosition());
        chartConfig.setExtendedLegend(this.config.isExtendedLegend());
        chartConfig.setGridVisible(this.config.isShowGrid());
        chartConfig.setLogScale(this.config.isLogScaleEnabled());
        chartConfig.setStacked(this.config.isStacked());
        chartConfig.setLineWidth(this.config.getLineWidth());
        chartConfig.setArea(this.config.isArea());
        chartConfig.setTranslucent(this.config.isTranslucent());
        chartConfig.setUseMultipliers(this.config.isUseMultipliers());
        chartConfig.setAutoScale(this.config.isAutoScale());
        chartConfig.setMinYScaleValue(this.config.getMinYScaleValue());
        chartConfig.setMaxYScaleValue(this.config.getMaxYScaleValue());
        chartConfig.setModifyYBase(this.config.modifyYBase());
        this.chart = new Chart(this.getContentArea(), 0, ChartType.LINE, chartConfig);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (LineChartElement.this.refreshController != null) {
                    LineChartElement.this.refreshController.dispose();
                }
            }
        });
        if (this.config.isInteractive()) {
            this.createActions();
            this.createChartContextMenu();
        }
        this.configureMetrics();
    }

    private void configureMetrics() {
        ConsoleJob job = new ConsoleJob("Get DCI info", null, "org.netxms.ui.eclipse.dashboard", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DciValue[] nodeDciList = null;
                ChartDciConfig[] chartDciConfigArray = LineChartElement.this.config.getDciList();
                int n = chartDciConfigArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ChartDciConfig dci = chartDciConfigArray[n2];
                    if (dci.nodeId == 0L || dci.nodeId == 0xFFFFFFFFL) {
                        AbstractObject contextObject = LineChartElement.this.getContext();
                        if (contextObject != null) {
                            if (nodeDciList == null) {
                                nodeDciList = LineChartElement.this.session.getLastValues(contextObject.getObjectId());
                            }
                            Pattern namePattern = Pattern.compile(dci.dciName);
                            Pattern descriptionPattern = Pattern.compile(dci.dciDescription);
                            DciValue[] dciValueArray = nodeDciList;
                            int n3 = nodeDciList.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                DciValue dciInfo = dciValueArray[n4];
                                if (!dci.dciName.isEmpty() && namePattern.matcher(dciInfo.getName()).find() || !dci.dciDescription.isEmpty() && descriptionPattern.matcher(dciInfo.getDescription()).find()) {
                                    ChartDciConfig instance = new ChartDciConfig(dciInfo);
                                    LineChartElement.this.runtimeDciList.add(instance);
                                    if (!dci.multiMatch) break;
                                }
                                ++n4;
                            }
                        }
                    } else {
                        LineChartElement.this.runtimeDciList.add(dci);
                    }
                    ++n2;
                }
                final Map measurementUnits = LineChartElement.this.session.getDciMeasurementUnits(LineChartElement.this.runtimeDciList);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).LineChartElement.this.chart.isDisposed()) {
                            return;
                        }
                        for (ChartDciConfig dci : (this).LineChartElement.this.runtimeDciList) {
                            GraphItem item = new GraphItem(dci);
                            item.setMeasurementUnit((MeasurementUnit)measurementUnits.get(dci.getDciId()));
                            (this).LineChartElement.this.chart.addParameter(item);
                        }
                        (this).LineChartElement.this.chart.rebuild();
                        LineChartElement.this.layout(true, true);
                        LineChartElement.this.refreshData();
                        (this).LineChartElement.this.refreshController = new ViewRefreshController((this).LineChartElement.this.viewPart, (this).LineChartElement.this.config.getRefreshRate(), new Runnable(){

                            @Override
                            public void run() {
                                if (LineChartElement.this.isDisposed()) {
                                    return;
                                }
                                LineChartElement.this.refreshData();
                            }
                        });
                    }
                });
            }

            protected String getErrorMessage() {
                return null;
            }
        };
        job.setUser(false);
        job.start();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                LineChartElement.this.refreshData();
            }
        };
        this.actionAdjustX = HistoricalGraphView.createAction((HistoricalGraphView.ChartActionType)HistoricalGraphView.ChartActionType.ADJUST_X, (HistoricalGraphView.HistoricalChartOwner)this);
        this.actionAdjustY = HistoricalGraphView.createAction((HistoricalGraphView.ChartActionType)HistoricalGraphView.ChartActionType.ADJUST_Y, (HistoricalGraphView.HistoricalChartOwner)this);
        this.actionAdjustBoth = HistoricalGraphView.createAction((HistoricalGraphView.ChartActionType)HistoricalGraphView.ChartActionType.ADJUST_BOTH, (HistoricalGraphView.HistoricalChartOwner)this);
        this.presetActions = HistoricalGraphView.createPresetActions((HistoricalGraphView.PresetHandler)new HistoricalGraphView.PresetHandler(){

            public void onPresetSelected(TimeUnit unit, int range) {
                LineChartElement.this.config.setTimeUnits(unit.getValue());
                LineChartElement.this.config.setTimeRange(range);
                LineChartElement.this.refreshData();
            }
        });
    }

    private void createChartContextMenu() {
        final MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                LineChartElement.this.fillContextMenu((IMenuManager)manager);
            }
        });
        this.chart.setMenuManager(manager);
    }

    private void fillContextMenu(IMenuManager manager) {
        MenuManager presets = new MenuManager("&Presets");
        int i = 0;
        while (i < this.presetActions.length) {
            presets.add((IAction)this.presetActions[i]);
            ++i;
        }
        manager.add((IContributionItem)presets);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.LineChartElement_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.dashboard"){
            private ChartDciConfig currentDci;

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Date from = new Date(System.currentTimeMillis() - LineChartElement.this.config.getTimeRangeMillis());
                final Date to = new Date(System.currentTimeMillis());
                final DciData[] data = new DciData[LineChartElement.this.runtimeDciList.size()];
                final Threshold[][] thresholds = new Threshold[LineChartElement.this.runtimeDciList.size()][];
                int i = 0;
                while (i < LineChartElement.this.runtimeDciList.size()) {
                    this.currentDci = LineChartElement.this.runtimeDciList.get(i);
                    if (this.currentDci.type == 1) {
                        data[i] = LineChartElement.this.session.getCollectedData(this.currentDci.nodeId, this.currentDci.dciId, from, to, 0, HistoricalDataType.PROCESSED);
                        thresholds[i] = LineChartElement.this.session.getThresholds(this.currentDci.nodeId, this.currentDci.dciId);
                    } else {
                        data[i] = LineChartElement.this.session.getCollectedTableData(this.currentDci.nodeId, this.currentDci.dciId, this.currentDci.instance, this.currentDci.column, from, to, 0);
                        thresholds[i] = null;
                    }
                    ++i;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).LineChartElement.this.chart.isDisposed()) {
                            (this).LineChartElement.this.dataCache.clear();
                            (this).LineChartElement.this.chart.setTimeRange(from, to);
                            int i = 0;
                            while (i < data.length) {
                                (this).LineChartElement.this.chart.updateParameter(i, data[i], false);
                                (this).LineChartElement.this.dataCache.add(new DataCacheElement((this).LineChartElement.this.runtimeDciList.get(i), data[i]));
                                ++i;
                            }
                            (this).LineChartElement.this.chart.setThresholds(thresholds);
                            (this).LineChartElement.this.chart.refresh();
                            (this).LineChartElement.this.chart.clearErrors();
                        }
                        (this).LineChartElement.this.updateInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.LineChartElement_JobError, LineChartElement.this.session.getObjectName(this.currentDci.nodeId), this.currentDci.name);
            }

            protected void jobFailureHandler() {
                LineChartElement.this.updateInProgress = false;
                super.jobFailureHandler();
            }

            protected IStatus createFailureStatus(final Exception e) {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).LineChartElement.this.chart.addError(String.valueOf(this.getErrorMessage()) + " (" + e.getLocalizedMessage() + ")");
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.start();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (hHint == -1 && size.y < 210) {
            size.y = 210;
        }
        return size;
    }

    public List<DataCacheElement> getDataCache() {
        return new ArrayList<DataCacheElement>(this.dataCache);
    }

    public Chart getChart() {
        return this.chart;
    }

    public class DataCacheElement {
        public DciData data;
        public String name;

        public DataCacheElement(ChartDciConfig config, DciData data) {
            this.name = config.getLabel();
            this.data = data;
        }
    }
}

