/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Rack;
import org.netxms.ui.eclipse.console.resources.ThemeEngine;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.widgets.RackWidget;
import org.netxms.ui.eclipse.objectview.widgets.helpers.ElementSelectionListener;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class RackTab
extends ObjectTab
implements ISelectionProvider {
    private ScrolledComposite scroller;
    private Composite content;
    private RackWidget rackFrontWidget;
    private RackWidget rackRearWidget;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();

    @Override
    protected void createTabContent(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 256);
        this.content = new Composite((Composite)this.scroller, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                if (RackTab.this.rackFrontWidget == null || RackTab.this.rackRearWidget == null || hHint == -1) {
                    return super.computeSize(wHint, hHint, changed);
                }
                Point s = RackTab.this.rackFrontWidget.computeSize(wHint, hHint, changed);
                return new Point(s.x * 2, s.y);
            }
        };
        this.content.setBackground(ThemeEngine.getBackgroundColor((String)"Rack"));
        this.content.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (RackTab.this.rackFrontWidget == null || RackTab.this.rackRearWidget == null) {
                    return;
                }
                RackTab.this.updateRackWidgetsSize();
            }
        });
        this.scroller.setContent((Control)this.content);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                RackTab.this.scroller.setMinSize(RackTab.this.content.computeSize(-1, RackTab.this.scroller.getSize().y));
            }
        });
    }

    protected void updateRackWidgetsSize() {
        int height = this.content.getSize().y;
        Point size = this.rackFrontWidget.computeSize(-1, height, true);
        this.rackFrontWidget.setSize(size);
        this.rackRearWidget.setSize(size);
        this.rackRearWidget.setLocation(size.x, 0);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                RackTab.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.rackFrontWidget);
        this.rackFrontWidget.setMenu(menu);
        menu = menuMgr.createContextMenu((Control)this.rackRearWidget);
        this.rackRearWidget.setMenu(menu);
        this.getViewPart().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.selection != null && ((IStructuredSelection)this.selection).getFirstElement() instanceof AbstractObject) {
            ObjectContextMenu.fill((IMenuManager)manager, (IShellProvider)this.getViewPart().getSite(), (ISelectionProvider)this);
        }
    }

    @Override
    public void currentObjectUpdated(AbstractObject object) {
        this.objectChanged(object);
    }

    @Override
    public void refresh() {
    }

    @Override
    public void objectChanged(AbstractObject object) {
        if (this.rackFrontWidget != null) {
            this.rackFrontWidget.dispose();
            this.rackFrontWidget = null;
        }
        if (this.rackRearWidget != null) {
            this.rackRearWidget.dispose();
            this.rackRearWidget = null;
        }
        if (object != null) {
            ElementSelectionListener listener = new ElementSelectionListener(){

                @Override
                public void objectSelected(Object object) {
                    RackTab.this.selection = object != null ? new StructuredSelection(object) : new StructuredSelection();
                    for (ISelectionChangedListener listener : RackTab.this.selectionListeners) {
                        listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)RackTab.this, RackTab.this.selection));
                    }
                }
            };
            this.rackFrontWidget = new RackWidget(this.content, 0, (Rack)object, RackOrientation.FRONT);
            this.rackFrontWidget.addSelectionListener(listener);
            this.rackRearWidget = new RackWidget(this.content, 0, (Rack)object, RackOrientation.REAR);
            this.rackRearWidget.addSelectionListener(listener);
            this.scroller.setMinSize(this.content.computeSize(-1, this.scroller.getSize().y));
            this.updateRackWidgetsSize();
            this.createPopupMenu();
        }
    }

    @Override
    public boolean showForObject(AbstractObject object) {
        return object instanceof Rack;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    @Override
    public void selected() {
        super.selected();
        this.scroller.setContent((Control)this.content);
    }
}

