/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netxms.client.search.SearchAttributeProvider;

public class SearchQuery {
    private Set<String> includedTexts = null;
    private Set<String> excludedTexts = null;
    private Map<String, Set<String>> includedAttributes = null;
    private Map<String, Set<String>> excludedAttributes = null;

    public SearchQuery(String source) {
        char[] input = source.toCharArray();
        int position = 0;
        int start = -1;
        int state = 0;
        boolean negateNext = false;
        Set<String> attributeValues = null;
        while (position <= input.length) {
            int ch = position < input.length ? input[position] : 32;
            switch (state) {
                case 0: {
                    if (ch == 34) {
                        state = 3;
                        start = position + 1;
                        break;
                    }
                    if (Character.isWhitespace(ch)) break;
                    state = 1;
                    start = position;
                    break;
                }
                case 1: {
                    Map<String, Set<String>> attributes;
                    if (Character.isWhitespace(ch)) {
                        String text = new String(input, start, position - start);
                        if (text.equalsIgnoreCase("not")) {
                            negateNext = true;
                        } else if (negateNext) {
                            if (this.excludedTexts == null) {
                                this.excludedTexts = new HashSet<String>();
                            }
                            this.excludedTexts.add(text.toLowerCase());
                            negateNext = false;
                        } else {
                            if (this.includedTexts == null) {
                                this.includedTexts = new HashSet<String>();
                            }
                            this.includedTexts.add(text.toLowerCase());
                        }
                        state = 0;
                        break;
                    }
                    if (ch != 58) break;
                    if (input[start] == '-' || negateNext) {
                        if (this.excludedAttributes == null) {
                            this.excludedAttributes = new HashMap<String, Set<String>>();
                        }
                        attributes = this.excludedAttributes;
                        if (input[start] == '-') {
                            ++start;
                        }
                        negateNext = false;
                    } else {
                        if (this.includedAttributes == null) {
                            this.includedAttributes = new HashMap<String, Set<String>>();
                        }
                        attributes = this.includedAttributes;
                    }
                    String name = new String(input, start, position - start).toLowerCase();
                    attributeValues = attributes.get(name);
                    if (attributeValues == null) {
                        attributeValues = new HashSet<String>();
                        attributes.put(name, attributeValues);
                    }
                    start = position + 1;
                    state = 2;
                    break;
                }
                case 2: {
                    if (!Character.isWhitespace(ch) && ch != 44) break;
                    String v = new String(input, start, position - start).toLowerCase();
                    if (!v.isEmpty()) {
                        attributeValues.add(v);
                    }
                    if (ch == 44) {
                        start = position + 1;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 3: {
                    if (ch != 34) break;
                    if (negateNext) {
                        if (this.excludedTexts == null) {
                            this.excludedTexts = new HashSet<String>();
                        }
                        this.excludedTexts.add(new String(input, start, position - start).toLowerCase());
                        negateNext = false;
                    } else {
                        if (this.includedTexts == null) {
                            this.includedTexts = new HashSet<String>();
                        }
                        this.includedTexts.add(new String(input, start, position - start).toLowerCase());
                    }
                    state = 0;
                }
            }
            ++position;
        }
    }

    public boolean match(Object object) {
        String text;
        String string = text = object instanceof SearchAttributeProvider ? ((SearchAttributeProvider)object).getText().toLowerCase() : object.toString().toLowerCase();
        if (this.excludedTexts != null) {
            for (String string2 : this.excludedTexts) {
                if (!text.contains(string2)) continue;
                return false;
            }
        }
        if (this.includedTexts != null) {
            for (String string3 : this.includedTexts) {
                if (text.contains(string3)) continue;
                return false;
            }
        }
        if (object instanceof SearchAttributeProvider) {
            String value;
            if (this.excludedAttributes != null) {
                for (Map.Entry entry : this.excludedAttributes.entrySet()) {
                    value = ((SearchAttributeProvider)object).getAttribute((String)entry.getKey());
                    if (value == null || !((Set)entry.getValue()).contains(value.toLowerCase())) continue;
                    return false;
                }
            }
            if (this.includedAttributes != null) {
                for (Map.Entry entry : this.includedAttributes.entrySet()) {
                    value = ((SearchAttributeProvider)object).getAttribute((String)entry.getKey());
                    if (value != null && ((Set)entry.getValue()).contains(value.toLowerCase())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public String toString() {
        return "SearchQuery [includedTexts=" + this.includedTexts + ", excludedTexts=" + this.excludedTexts + ", includedAttributes=" + this.includedAttributes + ", excludedAttributes=" + this.excludedAttributes + "]";
    }
}

