/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import java.util.Iterator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.ui.IViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.ServiceComponentsConfig;
import org.netxms.ui.eclipse.networkmaps.widgets.NetworkMapWidget;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ColorConverter;

public class ServiceComponentsElement
extends ElementWidget {
    private NetworkMapWidget mapWidget;
    private NetworkMapPage mapPage;
    private ServiceComponentsConfig config;
    private NXCSession session;

    protected ServiceComponentsElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = ServiceComponentsConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new ServiceComponentsConfig();
        }
        this.processCommonSettings(this.config);
        this.session = ConsoleSharedData.getSession();
        long rootObjectId = this.getEffectiveObjectId(this.config.getObjectId());
        AbstractObject rootObject = this.session.findObjectById(rootObjectId);
        this.mapPage = new NetworkMapPage("org.netxms.ui.eclipse.networkmaps.views.ServiceComponents" + rootObjectId);
        long elementId = this.mapPage.createElementId();
        this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, rootObjectId));
        this.addServiceComponents(rootObject, elementId);
        if (this.mapPage != null) {
            this.mapWidget = new NetworkMapWidget(this.getContentArea(), viewPart, 0);
            this.mapWidget.setLayoutAlgorithm(this.config.getDefaultLayoutAlgorithm());
            this.mapWidget.zoomTo((double)this.config.getZoomLevel() / 100.0);
            this.mapWidget.getLabelProvider().setObjectFigureType(this.config.getObjectDisplayMode());
            this.mapWidget.getLabelProvider().setShowStatusIcons((this.config.getFlags() & 1) != 0);
            this.mapWidget.getLabelProvider().setShowStatusFrame((this.config.getFlags() & 2) != 0);
            this.mapWidget.getLabelProvider().setShowStatusBackground((this.config.getFlags() & 4) != 0);
            this.mapWidget.getLabelProvider().setTranslucentLabelBackground((this.config.getFlags() & 0x200) != 0);
            this.mapWidget.setConnectionRouter(this.config.getDefaultLinkRouting());
            if (this.config.getDefaultLinkColor() >= 0) {
                this.mapWidget.getLabelProvider().setDefaultLinkColor(new Color((Device)this.mapWidget.getControl().getDisplay(), ColorConverter.rgbFromInt((int)this.config.getDefaultLinkColor())));
            }
            this.mapWidget.setContent(this.mapPage);
        }
        if (this.config.isObjectDoubleClickEnabled()) {
            this.mapWidget.enableObjectDoubleClick();
        }
    }

    private void addServiceComponents(AbstractObject object, long parentElementId) {
        Iterator it = object.getChildren();
        while (it.hasNext()) {
            long objectId = (Long)it.next();
            AbstractObject child = this.session.findObjectById(objectId);
            if (child == null || !(child instanceof Container) && !(child instanceof Cluster) && !(child instanceof Node) && !(child instanceof Condition)) continue;
            long elementId = this.mapPage.createElementId();
            this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, objectId));
            this.mapPage.addLink(new NetworkMapLink(this.mapPage.createLinkId(), 0, parentElementId, elementId));
            this.addServiceComponents(child, elementId);
        }
    }
}

