/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.application.EntryPoint;
import org.eclipse.rap.rwt.client.service.ExitConfirmation;
import org.eclipse.rap.rwt.client.service.StartupParameters;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.VersionInfo;
import org.netxms.certificate.manager.CertificateManagerProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AuthenticationType;
import org.netxms.nxmc.AppPropertiesLoader;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.Startup;
import org.netxms.nxmc.base.dialogs.PasswordExpiredDialog;
import org.netxms.nxmc.base.login.LoginDialog;
import org.netxms.nxmc.base.login.LoginJob;
import org.netxms.nxmc.base.windows.MainWindow;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.alarms.AlarmNotifier;
import org.netxms.nxmc.modules.datacollection.SummaryTablesCache;
import org.netxms.nxmc.modules.datacollection.api.GraphTemplateCache;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.DataCollectionDisplayInfo;
import org.netxms.nxmc.modules.objects.ObjectIcons;
import org.netxms.nxmc.modules.objecttools.ObjectToolsCache;
import org.netxms.nxmc.modules.snmp.shared.MibCache;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class Startup
implements EntryPoint,
StartupParameters {
    private static Logger logger = LoggerFactory.getLogger(Startup.class);
    private I18n i18n = LocalizationHelper.getI18n(Startup.class);
    private Display display;
    private Shell shell;

    public int createUI() {
        this.display = new Display();
        this.display.setData("org.eclipse.rap.rwt.cancelKeys", (Object)new String[]{"CTRL+F", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10"});
        this.display.setData("org.eclipse.rap.rwt.activeKeys", (Object)new String[]{"CTRL+F", "CTRL+F2", "F5", "F7", "F8", "F10"});
        File tempDir = (File)RWT.getUISession().getHttpSession().getServletContext().getAttribute("javax.servlet.context.tempdir");
        File stateDir = new File(tempDir + File.separator + "state");
        if (!stateDir.isDirectory()) {
            stateDir.mkdir();
        }
        Registry.setStateDir((File)stateDir);
        logger.info("NetXMS Management Console version " + VersionInfo.version() + " starting");
        logger.info("State directory: " + stateDir.getAbsolutePath());
        StringBuilder sb = new StringBuilder();
        for (String themeId : ((ApplicationContextImpl)RWT.getApplicationContext()).getThemeManager().getRegisteredThemeIds()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(themeId);
        }
        logger.info("Registered themes: " + sb.toString());
        PreferenceStore.open((String)stateDir.getAbsolutePath());
        DateFormatFactory.createInstance();
        SharedIcons.init();
        StatusDisplayInfo.init((Display)this.display);
        ObjectIcons.init((Display)this.display);
        Shell shell = new Shell(this.display, 8);
        shell.setMaximized(true);
        shell.open();
        if (!this.doLogin()) {
            logger.info("Application instance exit");
            this.display.dispose();
            return 0;
        }
        NXCSession session = Registry.getSession();
        DataCollectionDisplayInfo.init();
        MibCache.init((NXCSession)session, (Display)this.display);
        ObjectToolsCache.init();
        ObjectToolsCache.attachSession((Display)this.display, (NXCSession)session);
        SummaryTablesCache.attachSession((Display)this.display, (NXCSession)session);
        GraphTemplateCache.attachSession((Display)this.display, (NXCSession)session);
        ExitConfirmation exitConfirmation = (ExitConfirmation)RWT.getClient().getService(ExitConfirmation.class);
        exitConfirmation.setMessage(this.i18n.tr("This will terminate your current session. Are you sure?"));
        MainWindow w = new MainWindow(shell);
        Registry.setMainWindow((MainWindow)w);
        w.setBlockOnOpen(true);
        w.open();
        logger.info("Application instance exit");
        AlarmNotifier.stop();
        this.display.dispose();
        return 0;
    }

    private boolean doLogin() {
        PreferenceStore settings = PreferenceStore.getInstance();
        boolean success = false;
        boolean autoConnect = false;
        boolean ignoreProtocolVersion = false;
        String password = "";
        HttpServletRequest request = RWT.getRequest();
        String s = request.getParameter("login");
        if (s != null) {
            settings.set("Connect.Login", s);
        }
        if ((s = request.getParameter("password")) != null) {
            password = s;
            settings.set("Connect.AuthMethod", AuthenticationType.PASSWORD.getValue());
        }
        if ((s = request.getParameter("auto")) != null) {
            autoConnect = true;
        }
        AppPropertiesLoader appProperties = new AppPropertiesLoader();
        settings.set("Connect.Server", appProperties.getProperty("server", "127.0.0.1"));
        LoginDialog loginDialog = new LoginDialog(this.shell, appProperties);
        while (!success) {
            if (!autoConnect) {
                if (loginDialog.open() != 0) {
                    logger.info("Login cancelled by user - exiting");
                    return false;
                }
                password = loginDialog.getPassword();
            } else {
                autoConnect = false;
            }
            LoginJob job = new LoginJob(this.display, ignoreProtocolVersion);
            job.setPassword(password);
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(null);
            try {
                monitorDialog.run(true, false, (IRunnableWithProgress)job);
                success = true;
            }
            catch (InvocationTargetException e) {
                logger.error("Login job failed", e.getCause());
                MessageDialog.openError(null, (String)this.i18n.tr("Connection Error"), (String)e.getCause().getLocalizedMessage());
            }
            catch (Exception e) {
                logger.error("Unexpected exception while running login job", (Throwable)e);
                MessageDialog.openError(null, (String)this.i18n.tr("Internal error"), (String)e.toString());
            }
        }
        CertificateManagerProvider.dispose();
        NXCSession session = Registry.getSession();
        if (session.getAuthenticationMethod() == AuthenticationType.PASSWORD && session.isPasswordExpired()) {
            this.requestPasswordChange(loginDialog.getPassword(), session);
        }
        return true;
    }

    private void requestPasswordChange(String currentPassword, NXCSession session) {
        PasswordExpiredDialog dlg = new PasswordExpiredDialog(null, session.getGraceLogins());
        while (dlg.open() == 0) {
            1 job = new /* Unavailable Anonymous Inner Class!! */;
            try {
                ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(null);
                monitorDialog.run(true, false, (IRunnableWithProgress)job);
                MessageDialogHelper.openInformation(null, (String)this.i18n.tr("Information"), (String)this.i18n.tr("Password changed successfully"));
                return;
            }
            catch (InvocationTargetException e) {
                MessageDialogHelper.openError(null, (String)this.i18n.tr("Error"), (String)String.format(this.i18n.tr("Cannot change password (%s)"), e.getCause().getLocalizedMessage()));
                continue;
            }
            catch (InterruptedException e) {
                logger.error("Unexpected exception while doing password change", (Throwable)e);
                MessageDialog.openError(null, (String)this.i18n.tr("Internal error"), (String)e.toString());
                continue;
            }
            break;
        }
        return;
    }

    public Collection<String> getParameterNames() {
        StartupParameters service = (StartupParameters)RWT.getClient().getService(StartupParameters.class);
        return service == null ? new ArrayList() : service.getParameterNames();
    }

    public String getParameter(String name) {
        StartupParameters service = (StartupParameters)RWT.getClient().getService(StartupParameters.class);
        return service == null ? null : service.getParameter(name);
    }

    public List<String> getParameterValues(String name) {
        StartupParameters service = (StartupParameters)RWT.getClient().getService(StartupParameters.class);
        return service == null ? null : service.getParameterValues(name);
    }
}

