/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.views;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractTraceView;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.PerspectiveConfiguration;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.services.MonitorDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class MonitorPerspective
extends Perspective {
    private static final Logger logger = LoggerFactory.getLogger(MonitorPerspective.class);
    private static final I18n i18n = LocalizationHelper.getI18n(MonitorPerspective.class);
    private List<MonitorDescriptor> monitors = new ArrayList();

    public MonitorPerspective() {
        super("Monitor", i18n.tr("Monitor"), ResourceManager.getImage((String)"icons/perspective-monitor.png"));
        ServiceLoader<MonitorDescriptor> loader = ServiceLoader.load(MonitorDescriptor.class, this.getClass().getClassLoader());
        for (MonitorDescriptor e : loader) {
            this.monitors.add(e);
        }
        this.monitors.sort((m1, m2) -> m1.getDisplayName().compareToIgnoreCase(m2.getDisplayName()));
    }

    protected void configurePerspective(PerspectiveConfiguration configuration) {
        super.configurePerspective(configuration);
        configuration.hasNavigationArea = false;
        configuration.multiViewMainArea = true;
        configuration.hasSupplementalArea = false;
        configuration.priority = 150;
    }

    protected void configureViews() {
        NXCSession session = Registry.getSession();
        for (MonitorDescriptor e : this.monitors) {
            String componentId = e.getRequiredComponentId();
            if (componentId == null || session.isServerComponentRegistered(componentId)) {
                AbstractTraceView view = e.createView();
                this.addMainView((View)view);
                logger.debug("Added monitor perspective view \"" + view.getName() + "\"");
                continue;
            }
            logger.debug("Monitor perspective view \"" + e.getDisplayName() + "\" blocked by component filter");
        }
    }
}

